/*
 * @LASToolsXMLStruct.java Version 1.0 08/30/2004
 *
 * Copyright (c) 2004 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package xml;

/** CLASS LASToolsXMLStruct
 *  <p> This Structure holds the LAS Standard Tool Data XML Macros.
 *
 *  @version 1.1 08/30/2004
 *  @author  John R. Victorine
 */

public class LASToolsXMLStruct
{
  // XML Macros

  public static final String ROOTNAME    = "las_tools"; // ROOT Name
  public static final String RECORDS     = "records";   // Total # of Records

  public static final String LAS_CURVE   = "log_curve"; // ELEMENT LAS CURVE
  public static final String TOOL        = "tool";      // ELEMENT LAS TOOL
  public static final String KEY         = "key";       //   TOOL KID
  public static final String MNEMONIC    = "mnemonic";  //   Curve Mnemonic
  public static final String DESCRIPTION = "desc";      //   Curve Description
  public static final String UNIT        = "unit";      //   Curve Unit
  public static final String STANDARD    = "log_stand"; //   Standard Name
  public static final String MINIMUM     = "min";       //   Minimum Plot Value
  public static final String MAXIMUM     = "max";       //   Maximum Plot Value
  public static final String TRACK       = "track";     //   Track

  public static final String OTHER       = "other";     // ELEMENT OTHER NAMES
  public static final String NAME        = "name";      // ELEMENT Name
  public static final String O_MNEMONIC  = "mn";        // OTHER Mnemonic Name

  // DTD used to for validation of Map Data List XML File or Stream

  public static final String DTD =
      "<!ELEMENT las_tools (log_curve*)>\n"            +
      "<!ATTLIST las_tools records CDATA #REQUIRED>\n" +
      "<!ELEMENT log_curve (tool*, other?)>\n"         +
      "<!ATTLIST tool key     CDATA #REQUIRED\n"       +
      "               mnemonic CDATA #REQUIRED\n"      +
      "               desc     CDATA #IMPLIED\n"       +
      "               unit     CDATA #IMPLIED\n"       +
      "               log_stand CDATA #IMPLIED\n"      +
      "               min      CDATA #IMPLIED\n"       +
      "               max      CDATA #IMPLIED\n"       +
      "               track    CDATA #IMPLIED>\n"      +
      "<!ELEMENT other (name)+>\n"                     +
      "<!ATTLIST other records CDATA #REQUIRED>\n"     +
      "<!ELEMENT name EMPTY>\n"                        +
      "<!ATTLIST name mn CDATA #REQUIRED>";
}