/*
 * @LASFileXMLStruct.java Version 1.0 02/23/2004
 *
 * Copyright (c) 2003 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package xml;

/** CLASS LASFileXMLStruct
 *  <p> This Structure holds the LAS File Data XML Macros.
 *
 *  @version 1.1 02/23/2004
 *  @author  John R. Victorine
 */

public class LASFileXMLStruct
{
  // XML Macros

  public static final String ROOTNAME      = "las_files";  // ROOT Name
  public static final String RECORDS       = "records";  // Total # of Records
  public static final String PROCESS       = "app";      // XML Process
  public static final String PROCESS_ID    = "v1";       // Process ID
  public static final String API_NUMBER    = "v2";       // API-Number
  public static final String WELL_KID      = "v3";       // Well Header KID

  public static final String LAS           = "las";      // LAS ELEMENT
  public static final String KEY           = "key";      // LAS File Primary KEY
  public static final String WELL_KEY      = "well_key"; // Well Primary KEY
  public static final String PATH_TYPE     = "location"; // Directory Path Type
  public static final String PATH          = "path";     // LAS URL Path
  public static final String FILENAME      = "filename"; // LAS Filename
  public static final String VERSION       = "ver";      // LAS Version
  public static final String NULL_VALUE    = "log_null"; // Null Value
  public static final String START_DEPTH   = "start";    // LAS Starting Depth
  public static final String END_DEPTH     = "end";      // LAS Ending Depth
  public static final String PROPRIETARY   = "proprietary"; // Proprietary

  public static final String TYPE          = "type";     // Type ELEMENT
  public static final String RESISTIVITY   = "ohm";      // Resistivity count
  public static final String DENSITY       = "density";  // Density Log count
  public static final String NEUTRON       = "neutron";  // Neutron Log count
  public static final String SONIC         = "sonic";    // Sonic Log count
  public static final String SP            = "sp";       // SP Log count
  public static final String GAMMA_RAY     = "gamma";    // Gamma Ray Log count
  public static final String CALIPER       = "caliper";  // Caliper Log count
  public static final String PE            = "pe";       // Photoelectric count
  public static final String THOR          = "th";       // Thorium count
  public static final String URAN          = "u";        // Uranium count
  public static final String POTA          = "p";        // Potassium count

  // DTD used to for validation of Map Data List XML File or Stream

  public static final String DTD =
    "<!ELEMENT las_files (las*, type?)+>\n"          +
    "<!ATTLIST las_files records CDATA #REQUIRED\n" + // Total # of Records
    "                    app     CDATA #IMPLIED\n"  + // XML Application
    "                    v1      CDATA #IMPLIED\n"  + // Variable 1
    "                    v2      CDATA #IMPLIED\n"  + // Variable 2
    "                    v3      CDATA #IMPLIED>\n" + // Variable 3
    "<!ELEMENT las  EMPTY>\n"                    +
    "<!ATTLIST las key      CDATA #REQUIRED\n"   + // Primary Key for LAS File
    "              well_key CDATA #REQUIRED\n"   + // Primary Key for Well
    "              location CDATA #IMPLIED\n"    + // Directory Path Type
    "              path     CDATA #REQUIRED\n"   + // URL Path to LAS File
    "              filename CDATA #REQUIRED\n"   + // Filename of the LAS File
    "              ver      CDATA #IMPLIED\n"    + // Version Number of LAS File
    "              log_null CDATA #IMPLIED\n"    + // Log Null Value
    "              start    CDATA #IMPLIED\n"    + // Starting Depth
    "              end      CDATA #IMPLIED\n"    + // Ending Depth
    "              proprietary CDATA #IMPLIED>"  +  // Proprietary
    "<!ELEMENT type EMPTY>\n"                    +
    "<!ATTLIST type ohm      CDATA #IMPLIED\n"   + // Resistivity Curve Count
    "               density  CDATA #IMPLIED\n"   + // Density Log Curve Count
    "               neutron  CDATA #IMPLIED\n"   + // Neutron Log Curve Count
    "               sonic    CDATA #IMPLIED\n"   + // Sonic Log Curve Count
    "               sp       CDATA #IMPLIED\n"   + // SP Log Curve Count
    "               gamma    CDATA #IMPLIED\n"   + // Gamma Ray Log Curve Count
    "               caliper  CDATA #IMPLIED\n"   + // Caliper Log Curve Count
    "               pe       CDATA #IMPLIED>";     // Photoelectric Factor
}