/*
 * @utilWaitAnimation.java Version 2.5 07/31/2002
 *
 * Copyright (c) 2001 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package util;

import javax.swing.*;
import java.awt.*;
import java.lang.*;
import java.net.*;
import java.awt.event.*;

/** Class utilWaitAnimation (guiWaitAnimation --> jVictorine's version)
 *  <p> This Class will create a Wait Animation Dialog using a pump as the image
 *
 *  @Version 2.5 07/31/2002 (original version 1.1 07/27/2001)
 *  @author JayaPrakash "J.P." Pakalapati (original author  Tyler Stransky)
 */

public class utilWaitAnimation extends JDialog
{
  private final static int ONE_SECOND=1000;
  private URL              urlCodeBase;
  private URL              urlImage;
  private int              numFrames = 16;
  public  int              currentImage = 1;
  private ImageIcon[]      images = new ImageIcon[numFrames-1];
  private JLabel           jl = new JLabel("Please Wait...");
  private String           sBase;
  private Timer            timer;

  /** Constructor utilWaitAnimation()
   *  <p> This is the Constructor for this class.
   *  @param sDirCodeBase = Base URL Path
   */

  public utilWaitAnimation(URL sDirCodeBase)
  {
    getContentPane().setBackground(Color.white);
    setTitle("Loading.....");
    setSize(250,200);

    for (int i=0;i < images.length;i++)
    {
      sBase = new String("images/Frames/" + (i+1) + ".gif");
      urlImage = getURL(sDirCodeBase, sBase);
      images[i] = new ImageIcon(urlImage);
    }

    getContentPane().add(jl);

    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
//    this.setLocation((d.width - this.getSize().width) / 2,
//                     (d.height - this.getSize().height) / 2);
    this.setLocation(50,50);
    this.setVisible(true);

    // create a timer

    timer=new Timer(ONE_SECOND/25,new ActionListener()
    {
      public void actionPerformed(ActionEvent evt)
      {
        currentImage++;
        if (currentImage > images.length-1)
        {
          currentImage = 1;
        }
        jl.setIcon(images[currentImage]);
      }
    });
  }

  /** METHOD stopAnimation()
   *  <p> This Method will stop the wait dialog and hide it.
   */

  public synchronized void stopAnimation()
  {
    //gnrClip.stop();
    timer.stop();
    this.dispose();
  }

  /** METHOD startAnimation()
   *  <p> This Method will start the wait dialog.
   */

  public synchronized void startAnimation()
  {
    //gnrClip.loop();
    timer.start();
    jl.setIcon(images[currentImage]);
//    this.show();
    this.setVisible(true);
  }

  /** METHOD getURL()
   *  <p> This method will locate the URL for the specific file.
   *  @param sDirCodeBase - URL base location for the Applet.
   *  @param filename     - Path & Filename of Image.
   */

  protected URL getURL(URL sDirCodeBase, String filename)
  {
     URL url = null;

     if (urlCodeBase == null)
     {
       urlCodeBase = sDirCodeBase;
     }

     try
     {
       url = new URL(urlCodeBase, filename);
     }
     catch (java.net.MalformedURLException e)
     {
       String Message = new String("pfefferProcess(): \n" +
                                  e.getMessage() + "\n" +
                                  "Couldn't create image: " + filename);
       System.out.println(e.getMessage());
       JOptionPane.showMessageDialog((Component) null,
                                     Message,
                                     "ERROR",
                                     JOptionPane.ERROR_MESSAGE);
       return null;
     }

     return url;
  }

  /** Method setLabel()
   *  <p> This method will set the j1 label with a new text.
   *  @param label = the new sLabel.
   */

  public void setLabel(String sLabel)
  {
    jl.setText(sLabel);
  }
}
