/*
 * @utilMemory.java Version 1.1 02/20/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package util;

//import java.net.*;

/** Class utilMemory
 *  <p> This Class is designed monitor the memory usage.
 *
 *  @version 1.1 02/20/2009
 *  @author  John R. Victorine
 */

public class utilMemory
{
  /** Method getTotal()
   * <p> This method will return the total memory
   * @return memory = Total Memory
   */

  public static long getTotal()
  {
    long    memory = 0;
    Runtime r      = Runtime.getRuntime();

    memory = r.totalMemory();

    return (memory);
  }

  /** Method getFree()
   * <p> This method will return the free memory
   * @return memory = Free Memory
   */

  public static long getFree()
  {
    long    memory = 0;
    Runtime r      = Runtime.getRuntime();

    memory = r.freeMemory();

    return ( memory );
  }

  /** Method getMaximum()
   * <p> This method will return the free memory
   * @return memory = Maximum Memory
   */

  public static long getMaximum()
  {
    long    memory = 0;
    Runtime r      = Runtime.getRuntime();

    memory = r.maxMemory();

    return ( memory );
  }

  /** Method getPCUsage()
   * <p> This method will compute the percent of the Total PC Memory used
   * @return iPercent = Percent of memory used
   */

  public static int getPCUsage()
  {
    int iPercent = 0;

    iPercent = (int) ( (100 * getTotal()) / getMaximum() );

    return ( iPercent );
  }

  /** Method getFreeUsage()
   * <p> This method will compute the percent of the Total PC Memory used
   * @return iPercent = Percent of memory used
   */

  public static int getFreeUsage()
  {
    int iPercent = 0;

    iPercent = (int) ( (100 * (getTotal() - getFree())) / getTotal() );

    return ( iPercent );
  }

  /** Method free()
   * <p> this method will call the garbage collection to free memory
   */

  public static void free()
  {
    Runtime r = Runtime.getRuntime();

    r.runFinalization();
    r.gc();
  }
}

