/*
 * @utilBrowser.java Version 1.1 10/12/2001
 *
 * Copyright (c) 2001 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package util;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.net.URL;
import java.net.MalformedURLException;

/** Class utilBrowser
 *  <p> This Class is a default Browser Class that will take a URL String
 *      and Display the HTML, Image in a Browser Window.
 *
 *  @version 1.1 10/12/2001
 *  @author  John R. Victorine
 */

public class utilBrowser extends Frame
{
  String sPage    = "ALPHA";
  String sURLBase = new String("");
  AppletContext appletContext;

  /** CONSTRUCTOR utilBrowser()
   *  <p> This is the constructor for this class.
   *  @param appletContext - Applet Context
   *  @param sFile         - Web Address to be displayed.
   */

  public utilBrowser(AppletContext appletContext, String sFile)
  {
    super(sFile);

    sURLBase = new String(sFile);
    this.appletContext = appletContext;
    this.setURL();
  }

  /** Method newPage()
   * <p> This method will modify the Web Page.
   *  @param sFile         - Web Address to be displayed.
   */

  public void newPage(String sFile)
  {
    sURLBase = new String(sFile);
    this.setURL();
  }

  /** METHOD setURL()
   *  <p> Sets the URL location.
   */

   public void setURL()
   {
     String urlString = new String(sURLBase);

     URL url = null;
     try
     {
       url = new URL(urlString);
     }
     catch (MalformedURLException e)
     {
       System.err.println("Malformed URL: " + urlString);
     }

     if (url != null)
     {
       appletContext.showDocument(url, "_blank");
//       appletContext.showDocument(url, sPage);
     }
  }
}
