/*
 * @sedimentaryPlotLegendBuffered.java Version 1.1 03/10/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.sedimentary.plot;

import java.awt.*;
import java.awt.image.*;

import mask.maskSymbolsListStruct;
import rock.sedimentary.plot.sedimentaryPlotLegend;

/** Class sedimentaryPlotLegendBuffered
 *  <p> This Class will create a buffered image.
 *
 *  @version 1.1 03/10/2009
 *  @author  John R. Victorine
 */

public class sedimentaryPlotLegendBuffered
{
  /** Method makePlotImage( int iSedStruct[] )
   *  This method will plot well profile data.  The plot is then converted to
   *  a buffered image and passed back to the calling routine.
   *  @param  iSedStruct = array of identifiers to determine to plot image or not
   *  @param stSymbols   = Sedimentary Structure Plot Symbols List Data Structure
   *  @return image      = Sedimentary Structure Symbols plot buffered image
   */

  public static BufferedImage makePlotImage( int iSedStruct[],
                                             maskSymbolsListStruct stSymbols )
  {
    BufferedImage         image    = null;
    sedimentaryPlotLegend plot     = null;
    int                   iWidth   = 0;
    int                   iHeight  = 0;

    plot    = new sedimentaryPlotLegend( iSedStruct, stSymbols );
    iWidth  = plot.getPlotWidth();
    iHeight = plot.getPlotHeight();

    // Build Buffered Image

    image = new BufferedImage(iWidth, iHeight, BufferedImage.TYPE_INT_RGB);

    Graphics graphics = image.getGraphics();

    graphics.setColor(Color.white);
    graphics.fillRect(0, 0, iWidth, iHeight);

    plot.draw(graphics);

    graphics.dispose();

    return (image);
  }
}

