/*
 * @sedimentaryPlotDataEntry.java Version 1.1 09/19/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.sedimentary.plot;

import java.awt.*;
import java.awt.geom.*;

import mask.maskSymbolsListStruct;
import mask.plot.maskPlotSymbol;
import rock.sedimentary.sedimentaryStruct;

/** Class sedimentaryPlotDataEntry
 *  <p> This method will display the sedimentary structures selected
 *
 *  @version 1.1 09/19/2008
 *  @author  John R. Victorine
 */

public class sedimentaryPlotDataEntry extends Canvas
{
  private sedimentaryStruct     st        = null; // Sed Struct Data Structure
  private maskSymbolsListStruct stSymbols = null; // Sed Struct Symbols List
  private maskPlotSymbol        plot      = null; // Plot Mask Symbol

  private int iWidth  = 200;
  private int iHeight = 250;

  private static final int _START       = 10;
  private static final int _IMAGE_START = 20;
  private static final int _DESC_START  = 55;
  private static final int _DESCRIPTION = 65;
  private static final int _SEP         = 15;

  /** CONSTRUCTOR sedimentaryPlotDataEntry()
   *  <p> This is the constructor for this class.
   *  @param stSymbols = Sedimentary Structure Plot Symbols List Data Structure
   */

  public sedimentaryPlotDataEntry( maskSymbolsListStruct stSymbols )
  {
    this.stSymbols = stSymbols;

    plot = new maskPlotSymbol( stSymbols );
  }

  /** Method close()
   * <p> This method will force Java to deallocate memory
   */

  public void close()
  {
    stSymbols = null;

    if (plot != null)
      plot.close();
    plot = null;

    if (st != null)
      st.delete();
    st = null;
  }

  /* =============================================================== *
   * ------------------------- GET METHODS ------------------------- *
   * =============================================================== */

  /** Method getPlotWidth()
   * <p> This method will return the Width of the plot panel.
   * @return WIDTH = the width of the plot panel
   */

  public int getPlotWidth() { return (iWidth); }

  /** Method getPlotHeight()
   * <p> This method will return the Width of the plot panel.
   * @return the height of the plot panel
   */

  public int getPlotHeight() { return (iHeight); }

  /** Method getData()
   * <p> This method will get the array of sedimentary structures selected
   * @return st = sedimentary data Structure
   */

  public sedimentaryStruct getData() { return (st); }

  /* =============================================================== *
   * ------------------------- SET METHODS ------------------------- *
   * =============================================================== */

  /** Method setData()
   * <p> This method will set the array of sedimentary structures selected
   * @param st = sedimentary data Structure
   */

  public void setData(sedimentaryStruct st)
  {
	int    iFound = -1;
	int    len    = 0;
	String str    = "";

    this.st = st;

    iWidth  = 200;
    iHeight = 250;

    if (st != null)
	{
      iWidth  = 200;
      iHeight = 250;

	  if (st.iTotal > 0)
	  {
	    iHeight = _START + st.iTotal * _SEP;

        for (int i=0; i<st.iTotal; i++)
        {
          iFound = -1;
          for (int j=0; j<stSymbols.iCount; j++)
          {
            if (st.sID[i].equals(stSymbols.stItem[j].sID))
            {
              iFound = j;
            }
          }

          len    = 0;
          str    = "";

          if (iFound > -1)
          {
		    str = new String(stSymbols.stItem[iFound].sName.trim());
            len = _DESCRIPTION + 6 * str.length();
            if (len > iWidth)
              iWidth = len;
  		  }
        }
	  }
	}

    repaint();
  }

  /* ======================================================================== *
   * ------------------------------- PAINT ---------------------------------- *
   * ======================================================================== */

  /** Method draw()
   * <p> This method will draw the sedimentary image panels
   * @param g - Graphics Parameter.
   */

  public void draw(Graphics g)
  {
    int         i      = 0;
    int         j      = 0;
    int         iFound = -1;
    Font        fsb    = new Font("Serif", Font.BOLD, 12);
    FontMetrics fsbm   = g.getFontMetrics(fsb);

    g.setFont( fsb );

    if (st != null)
    {
      for (i=0; i<st.iTotal; i++)
      {
        iFound = -1;
        for (j=0; j<stSymbols.iCount; j++)
        {
          if (st.sID[i].equals(stSymbols.stItem[j].sID))
//                  rock.sedimentary.sedimentarySymbolsStruct.SYMBOLS[j][0]))
          {
            iFound = j;
          }
        }

        if (iFound > -1)
        {
          g.setColor( Color.black );
          g.drawLine( _DESC_START,      _START + i*_SEP + 6,
                      _DESC_START + 5,  _START + i*_SEP + 6 );
//          g.drawString(rock.sedimentary.sedimentarySymbolsStruct.SYMBOLS[iFound][3],
          g.drawString( stSymbols.stItem[iFound].sName,
                        _DESCRIPTION, _START + i*_SEP + 8 );

          plot.drawSymbol( g, stSymbols.stItem[iFound].iRows, 0,
                           stSymbols.stItem[iFound].symbol,
                           _IMAGE_START, _START + i*_SEP );

//          plot.plotMaskSymbol.drawSymbol(
//              g, 10,
//              rock.sedimentary.plot.sedimentaryPlotSymbolStruct.getSymbol(iFound),
//              _IMAGE_START, _START + i*_SEP);
        }
      }
    }
  }

  /** Method paint(Graphics g)
   * <p> This method will paint Porosity & Permeability Plot
   * @param g - Graphics Parameter.
   */

  public void paint(Graphics g)
  {
    g.setColor(Color.white);
    g.fillRect(0, 0, iWidth, iHeight);

    draw(g);
  }
}

/*
 *  @version 1.1 09/19/2008
 *  @author  John Victorine
 */
