/*
 * @sedimentaryPlotSymbolPanel.java Version 1.1 09/18/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.sedimentary.gui;

import java.awt.*;
import java.awt.image.*;
import java.util.Observable;
import javax.swing.*;

import mask.maskSymbolsListStruct;
import rock.sedimentary.plot.sedimentaryPlotSymbol;
import rock.sedimentary.sedimentaryStruct;

/** Class sedimentaryPlotSymbolPanel
 *  <p> This Class will display the sedimentary images available
 *
 *  @version 1.1 09/18/2008
 *  @author  John R. Victorine
 */

public class sedimentaryPlotSymbolPanel extends Panel
{
  private JFrame                parent    = null; // Frame callint this panel
  private Observable            notifier  = null; // Observable Object
  private maskSymbolsListStruct stSymbols = null; // Sed Struct Symbols List

  private int        iWidth  = 0;                // Width of the plot panel
  private int        iHeight = 0;                // Height of the plot panel

  private sedimentaryPlotSymbol plot = null;     // Fossil Plot Symbol Package

  private ScrollPane  scroll = new ScrollPane(); // Scroll Pane
  private JPanel      panel  = new JPanel();     // Panel containing plot

  /** Constructor sedimentaryPlotSymbolPanel()
   *  <p> This is the Constructor for this class.
   *  @param parent    = the frame calling this panel
   *  @param notifier  = Observable
   *  @param stSymbols = Sedimentary Structure Plot Symbols List Data Structure
   */

  public sedimentaryPlotSymbolPanel( JFrame parent, Observable notifier,
                                     maskSymbolsListStruct stSymbols )
  {
    try
    {
      this.parent    = parent;
      this.notifier  = notifier;
      this.stSymbols = stSymbols;

      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    Panel pnlCenter       = new Panel();

    this.setLayout(new BorderLayout());
    pnlCenter.setLayout(new BorderLayout());

    plot    = new sedimentaryPlotSymbol( notifier, stSymbols );
    iWidth  = plot.getPlotWidth();
    iHeight = plot.getPlotHeight();

    panel.setLayout(new BorderLayout());
    panel.setPreferredSize(new Dimension(iWidth, iHeight));
    panel.setBackground(Color.white);

    // Attach Widgets to Panel

    this.add(pnlCenter,          BorderLayout.CENTER);
    pnlCenter.add(scroll,        BorderLayout.CENTER);
    scroll.add(panel,            null);
    panel.add(plot,              BorderLayout.CENTER);
  }

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
    parent    = null; // Frame callint this panel
    notifier  = null; // Observable Object
    stSymbols = null; // Sed Struct Symbols List

    scroll    = null;
    panel     = null;

    if (plot != null)
      plot.close();
    plot    = null;
  }

  /* =============================================================== *
   * ------------------------- GET METHODS ------------------------- *
   * =============================================================== */

  /** Method getData()
   * <p> This method will get the array of sedimentary structure selected
   * @return st = sedimentary data Structure
   */

  public sedimentaryStruct getData()
  {
    sedimentaryStruct st = null;

    if (plot != null) st = plot.getData();

    return (st);
  }

  /* =============================================================== *
   * ------------------------- SET METHODS ------------------------- *
   * =============================================================== */

  /** Method setData()
   * <p> This method will set the array of sedimentary structure selected
   * @param st = sedimentary data Structure
   */

  public void setData(sedimentaryStruct st)
  {
    if (plot != null) plot.setData(st);
  }
}


/*
 *  @version 1.1 09/18/2008
 *  @author  John Victorine
 */
