/*
 * @sedimentaryPlotDataEntryPanel.java Version 1.1 09/19/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.sedimentary.gui;

import java.awt.*;
import java.awt.image.*;
import java.util.Observable;
import javax.swing.*;

import mask.maskSymbolsListStruct;
import rock.sedimentary.plot.sedimentaryPlotDataEntry;
import rock.sedimentary.sedimentaryStruct;

/** Class sedimentaryPlotDataEntryPanel
 *  <p> This Class will display the sedimentary structures selected
 *
 *  @version 1.1 09/19/2008
 *  @author  John R. Victorine
 */

public class sedimentaryPlotDataEntryPanel extends Panel
{
  private int iWidth  = 0; // Width of the plot panel
  private int iHeight = 0; // Height of the plot panel

  private maskSymbolsListStruct    stSymbols = null; // Sed Struct Symbols List
  private sedimentaryPlotDataEntry plot      = null; // Plot selected sed struct

  private ScrollPane  scroll = new ScrollPane(); // Scroll Pane
  private JPanel      panel  = new JPanel();     // Panel containing plot

  /** Constructor sedimentaryPlotDataEntryPanel()
   *  <p> This is the Constructor for this class.
   *  @param stSymbols = Sedimentary Structure Plot Symbols List Data Structure
   */

  public sedimentaryPlotDataEntryPanel( maskSymbolsListStruct stSymbols )
  {
    try
    {
      this.stSymbols = stSymbols;
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    Panel pnlCenter = new Panel();

    this.setLayout(new BorderLayout());
    pnlCenter.setLayout(new BorderLayout());

    plot    = new sedimentaryPlotDataEntry( stSymbols );
    iWidth  = plot.getPlotWidth();
    iHeight = plot.getPlotHeight();

    panel.setLayout(new BorderLayout());
    panel.setPreferredSize(new Dimension(iWidth, iHeight));
    panel.setBackground(Color.white);

    this.add(pnlCenter,   BorderLayout.CENTER);
    pnlCenter.add(scroll, BorderLayout.CENTER);
    scroll.add(panel,     null);
    panel.add(plot,       BorderLayout.CENTER);
  }

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
    stSymbols = null; // Sed Struct Symbols List
    scroll    = null;
    panel     = null;
    plot      = null;
  }

  /* =============================================================== *
   * ------------------------- GET METHODS ------------------------- *
   * =============================================================== */

  /** Method getData()
   * <p> This method will get the array of sedimentary structures selected
   * @return st = sedimentary data Structure
   */

  public sedimentaryStruct getData()
  {
    sedimentaryStruct st = null;

    if (plot != null) st = plot.getData();

    return (st);
  }

  /* =============================================================== *
   * ------------------------- SET METHODS ------------------------- *
   * =============================================================== */

  /** Method setData()
   * <p> This method will set the array of sedimentary structures selected
   * @param st = sedimentary data Structure
   */

  public void setData(sedimentaryStruct st)
  {
    if (plot != null)
    {
      plot.setData(st);

      iWidth  = plot.getPlotWidth();
      iHeight = plot.getPlotHeight();
      panel.setPreferredSize(new Dimension(iWidth, iHeight));
    }

    scroll.doLayout();
    panel.doLayout();
  }
}

/*
 *  @version 1.1 09/19/2008
 *  @author  John Victorine
 */
