/*
 * @rockImagesStruct.java Version 1.1 11/08/2007
 *
 * Copyright (c) 2004 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock;

/** Class rockImagesStruct
 *  <p> This class will hold the Rock Image Filename and location data.
 *
 *  @version 1.1 11/08/2007
 *  @author  John R. Victorine
 */

public class rockImagesStruct
{
  public String     sKID         = "0";  // Primary Key for Rock Image
  public String     sKEY         = "0";  // Primary Key Created by User
  public String     sLocation    = "";   // Location of File, KGS or PC
  public String     sURL         = "";   // URL Path
  public String     sDirectory   = "";   // Directory Path
  public String     sFilename    = "";   // Filename
  public String     sOriginal    = "";   // Original Filename
  public String     sFormat      = "";   // Format of the image File, JPEG, GIF, etc.
  public String     sType        = "";   // Core Image Type, CORE, SLAB, THIN SECTION
  public double     depthStart   = 0.0;  // Start Depth
  public double     depthEnd     = 0.0;  // Ending Depth
  public String     sAuthors     = "";   // Authors
  public String     sYear        = "";   // Year
  public String     sTitle       = "";   // Title
  public String     source       = "";   // Source
  public String     sDate        = "";   // Update Date
  public String     sThumbnail   = "";   // Thumbnail Made (Y,N)
  public String     sDescription = "";   // Description
  public String     sComments    = "";   // Comments

  /** Method delete()
   * <p> This method will force set the Objects to null and force Java to
   *     free unwanted memory
   */

  public void delete()
  {
    sKID         = null;   // Primary Key for Rock Image
    sKEY         = null;   // Primary Key Created by User
    sLocation    = null;   // Location of File, KGS or PC
    sURL         = null;   // URL Path
    sDirectory   = null;   // Directory Path
    sFilename    = null;   // Filename
    sOriginal    = null;   // Original Filename
    sFormat      = null;   // Format of the image File, JPEG, GIF, etc.
    sType        = null;   // Core Image Type, CORE, SLAB, THIN SECTION
    sAuthors     = null;   // Authors
    sYear        = null;   // Year
    sTitle       = null;   // Title
    source       = null;   // Source
    sDate        = null;   // Update Date
    sThumbnail   = null;   // Thumbnail Made (Y,N)
    sDescription = null;   // Description
    sComments    = null;   // Comments
  }

  public void print()
  {
    System.out.println("KID: "+sKID+" "+" KEY: "+sKEY+" Location: "+sLocation);
    System.out.println("  "+sURL+" "+sFilename+" "+sType);
  }
}
