/*
 * @rockImagesStandardTools.java Version 1.1 05/27/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock;

/** Class rockImagesStandardTools
 *  <p> This Class holds the standard tool information to map the
 *      Rock Image File curves to standard names.
 */

public class rockImagesStandardTools
{
  public static final int _IMGTOP  = 0;  // Start Depth
  public static final int _IMGBASE = 1;  // Ending Depth
  public static final int _IMGKID  = 2;  // KID
  public static final int _IMGLOC  = 3;  // Location of File, KGS or PC
  public static final int _IMGURL  = 4;  // URL Path
  public static final int _IMGFORM = 5;  // Format of the image File, JPEG, GIF, etc.
  public static final int _IMGTYPE = 6;  // Core Image Type, CORE, SLAB, THIN SECTION
  public static final int _IMGDIR  = 7;  // Directory Path
  public static final int _IMGFILE = 8;  // Filename
  public static final int _IMGYEAR = 9;  // Year
  public static final int _IMGTITL = 10;  // Title
  public static final int _IMGDES  = 11; // Description
  public static final int _IMGCOM  = 12; // Comments
  public static final int _IMGAUTH = 13; // Authors
  public static final int TOTAL    = 14; // Total

  public static final int _C_ID    = 0;  // Curve ID
  public static final int _C_MNEM  = 1;  // Curve Mnemonic
  public static final int _C_NAME  = 2;  // Curve Name
  public static final int _C_UNIT  = 3;  // Curve Units
  public static final int _C_FORM  = 4;  // Curve Format

  public static final String CURVES[][] =
  {
    // ID     MNEMONIC   CURVE NAME                                  UNIT  FORMAT
    { "1100", "IMGTOP",  "Start Depth",                               "F", "F" },
    { "1200", "IMGBASE", "Ending Depth",                              "F", "F" },
    { "1000", "IMGKID",  "KID",                                       "",  "S" },
    { "1300", "IMGLOC",  "Location of File, KGS or PC",               "",  "S" },
    { "1400", "IMGURL",  "URL Path",                                  "",  "S" },
    { "1500", "IMGFORM", "Format of the image File, JPEG, GIF, etc.", "",  "S" },
    { "1600", "IMGTYPE", "Core Image Type, CORE, SLAB, THIN SECTION", "",  "S" },
    { "1700", "IMGDIR",  "Directory Path",                            "",  "S" },
    { "1800", "IMGFILE", "Filename",                                  "",  "S" },
    { "2000", "IMGYEAR", "Year",                                      "",  "S" },
    { "2100", "IMGTITL", "Title",                                     "",  "S" },
    { "2200", "IMGDES",  "Description",                               "",  "S" },
    { "2300", "IMGCOM",  "Comments",                                  "",  "S" },
    { "2400", "IMGAUTH", "Authors",                                   "",  "S" },
  };

  /** Method isCurve()
   * <p> This method will determine if the curve is part of the standard
   *     stratigraphic units curves from the LAS File.
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return bValue  = true it is a valid curve, false it is not
   */

  public static boolean isCurve( int iColumn, String str )
  {
    boolean bValue = false;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        bValue = true;
      }
    }

    return (bValue);
  }

  /** Method getRow()
   * <p> This method will return the row number of the Stratigraphic Unit Curve
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return iRow = row number
   */

  public static int getRow( int iColumn, String str )
  {
    int iRow = -1;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        iRow = i;
      }
    }

    return (iRow);
  }
}