/*
 * @rockImagesListStruct.java Version 1.1 11/08/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock;

import rock.rockImagesStruct;

/** Class rockImagesListStruct
 *  <p> This class will holds a List of Rock Image Filename and location List
 *      Data Structures.
 *
 *  @version 1.1 11/08/2007
 *  @author  John R. Victorine
 */

public class rockImagesListStruct
{
  // Stratigraphic Headers Data Information

  public String sKID       = "0";  // Primary Key of the Well
  public String sKEY       = "";   // Primary Key created on user's PC
  public int    iType      = iqstrat.iqstratHeadersStruct.WELL; // Type of Data
  public String sAPI       = "";   // API-Number OR UWI
  public String sName      = "";   // Well Name or Outcrop Name
  public String status     = iqstrat.iqstratStatusStruct.STATUS[0][0]; // Status
  public double dLatitude  = 0.0;  // Latitude of Location
  public double dLongitude = 0.0;  // Longitude of Location
  public double depth      = 0.0;  // Total Depth of Well or Height of Outcrop
  public double dGL        = 0.0;  // Ground Level

  public double depthStart = 0.0;  // Starting Depth of the Rock Data
  public double depthEnd   = 0.0;  // Ending Depth of the Rock Data

  public String sKGS       = "YES"; // KGS Saved Data Indicator

  // LAS 3 Required Fields

  public String sIMAGE_SRC  = "";    // Image Source
  public String sIMAGE_DATE = "";    // Image Date

  // Other Core Parameters that are not in the Required List

  public int    iParamRows  = 0;      // Total number of rows
  public int    iParamCols  = las3.las3Struct._TOTAL; // Total number of columns
  public String sParams[][] = null;   // Array holding the Parameter Definitions

  // Images

  public int              iCount   = 0;    // Total number of Records
  public rockImagesStruct stItem[] = null; // Array of image data Structures

  /** Method delete()
   * <p> This method will force set the Objects to null and force Java to
   *     free unwanted memory
   */

  public void delete()
  {
    int i = 0;

    sKID   = null; // Primary Key of the Well
    sKEY   = null; // Primary Key created on user's PC
    sAPI   = null; // API-Number OR UWI
    sName  = null; // Well Name or Outcrop Name
    status = null; // Status

    for (i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }

  public void print()
  {
    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
      {
        stItem[i].print();
      }
    }
  }
}
