/*
 * @rockFileDataStruct.java Version 1.1 09/21/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock;

import iqstrat.iqstratShaleListStruct;

/** Class rockFileDataStruct
 *  <p> This Class holds the LAS File Well Data.
 *
 *  @version 1.1 09/21/2009
 *  @author  John R. Victorine
 */

public class rockFileDataStruct
{
  public int    iSource    = las3.las3Constants._SOURCE_NONE;

  // Well Information Data

  public String sKID       = "";  // Primary Key for the KGS Well
  public String sKEY       = "";  // Primary Key created by user
  public int    iType      = iqstrat.iqstratHeadersStruct.WELL; // Type of Data

  public String sAPI       = "";  // API-Number of Well
  public String sName      = "";  // Well Name
  public String state      = "";  // State Name
  public String sCounty    = "";  // County Name
  public String status     = "";  // Status of Well, i.e., OIL, GAS, etc.

  public double dLatitude  = 0.0; // Latitude of Well
  public double dLongitude = 0.0; // Longitude of Well

  public double dKB        = 0.0; // Kelly Bushing of Well
  public double dGL        = 0.0; // Ground Level of Well
  public double dTD        = 0.0; // Total Depth of Well

  // Rock Data Information

  public double dNull      = -999.95; // Null Value of Data
  public double depthStart = 0.0; // Start Depth
  public double depthEnd   = 0.0; // Ending Depth
  public double depthStep  = 0.0; // Depth Step

  public int    iProprietary = 0; // Proprietary Data Identfier

  // Unknown Curve Mnemonics

  public String sUnknown[][] = {
    {"", ""},
    {"", ""},
    {"", ""},
    {"", ""},
  };

  // Gamma Ray Curves

  public int iGR   = -1; // Gamma Ray Curve Number
  public int iCGR  = -1; // Gamma Ray Minus Uranium Curve Number
  public int iPGR  = -1; // Pseudo Gamma Ray Value

  // -- Density Data

  public int iGMCC  = -1; // Grain Density (gm/cc)
  public int iRHOD  = -1; // Density of Rock Dry (gm/cc)
  public int iRHOW  = -1; // Density of Rock Wet (gm/cc)

  // -- Porosity Data

  public int iPCORE = -1; // Porosity whole routine (PU)
  public int iPPLUG = -1; // Porosity Plug routine (PU)
  public int iP800  = -1; // Porosity Plug 800 PSI (PU)
  public int iPINSI = -1; // Porosity Plug Insitu (PU)
  public int iPEFF  = -1; // Effective Rock Porosity (PU)

  // -- Spectral Gamma Ray Data

  public int iTh    = -1; // Thorium Curve Number
  public int iU     = -1; // Uranium Curve Number
  public int iK     = -1; // Potasium Curve Number

  // Spectral Gamma Ray Ratios

  public int iThU   = -1; // Th/U
  public int iThK   = -1; // Th/K

  // -- Lithology Data

  public int iGRL   = -1; // Gamma Ray Curve Number
  public int iPHI   = -1; // Porosity Curve Number
  public int iRHOG  = -1; // "Grain" Density Curve Number

  // Unknown Linear Curves

  public int    iLIN_1  = -1;     // Linear Curve 1
  public int    iLIN_2  = -1;     // Linear Curve 2
  public int    iLIN_3  = -1;     // Linear Curve 3
  public int    iLIN_4  = -1;     // Linear Curve 4

  // Unknown Log Curves

  public int    iLOG_1  = -1;     // Log Curve 1
  public int    iLOG_2  = -1;     // Log Curve 2
  public int    iLOG_3  = -1;     // Log Curve 3
  public int    iLOG_4  = -1;     // Log Curve 4

  // Lithofacies Curves

  public int    iRows    = 0;    // Number of Rows
  public double depths[] = null; // Array of Depth Data Values

  public double dGR[]    = null; // Array of Gamma Ray Values
  public double dCGR[]   = null; // Array of Gamma Ray minus Uranium Values
  public double dPGR[]   = null; // Array of Pseudo Gamma Ray Values

  // Density Data

  public double dGMCC[]  = null; // Array of Grain Density (gm/cc) Values
  public double dRHOD[]  = null; // Array of Density of Rock Dry (gm/cc) Values
  public double dRHOW[]  = null; // Array of Density of Rock Wet (gm/cc) Values

  // Porosity Data

  public double dPCORE[] = null; // Array of Porosity whole routine (PU) Values
  public double dPPLUG[] = null; // Array of Porosity Plug routine (PU) Values
  public double dP800[]  = null; // Array of Porosity Plug 800 PSI (PU) Values
  public double dPINSI[] = null; // Array of Porosity Plug Insitu (PU) Values
  public double dPEFF[]  = null; // Array of Effective Rock Porosity (PU) Values

  // Spectral Gamma Ray Data

  public double dTh[]    = null; // Array of Thorium Values
  public double dU[]     = null; // Array of Uranium Values
  public double dK[]     = null; // Array of Potassium Values

  // Spectral Gamma Ray Lithology Curves

  public double dThU[]   = null; // Array of Th/U Ratio Values
  public double dThK[]   = null; // Array of Th/K Ratio Values

  // -- Lithology Data

  public double dGRL[]   = null; // Array of Gamma Ray Values
  public double dPHI[]   = null; // Array of Porosity Values
  public double dRHOG[]  = null; // Array of "Grain" Density Values

  // -- Unknown Linear Curves

  public double dLIN_1[]    = null; // Linear Curve 1
  public double dLIN_2[]    = null; // Linear Curve 2
  public double dLIN_3[]    = null; // Linear Curve 3
  public double dLIN_4[]    = null; // Linear Curve 4

  // -- Unknown Log Curves

  public double dLOG_1[]    = null; // Log Curve 1
  public double dLOG_2[]    = null; // Log Curve 2
  public double dLOG_3[]    = null; // Log Curve 3
  public double dLOG_4[]    = null; // Log Curve 4

  // -- Image Track Limits

  public double dPHIMin  = 0.0;
  public double dPHIMax  = 0.3;

  // .. Linear Curves

  public double dLIN_1Min = 0.0; // Linear Curve 1 Minimum
  public double dLIN_2Min = 0.0; // Linear Curve 2 Minimum
  public double dLIN_3Min = 0.0; // Linear Curve 3 Minimum
  public double dLIN_4Min = 0.0; // Linear Curve 4 Minimum

  public double dLIN_1Max = 1.0; // Linear Curve 1 Maximum
  public double dLIN_2Max = 1.0; // Linear Curve 2 Maximum
  public double dLIN_3Max = 1.0; // Linear Curve 3 Maximum
  public double dLIN_4Max = 1.0; // Linear Curve 4 Maximum

  // .. Semilog Curves

  public double dLOG_1Min = 0.1;    // Log Curve 1 Minimum
  public double dLOG_2Min = 0.1;    // Log Curve 2 Minimum
  public double dLOG_3Min = 0.1;    // Log Curve 3 Minimum
  public double dLOG_4Min = 0.1;    // Log Curve 4 Minimum

  public double dLOG_1Max = 1000.0; // Log Curve 1 Maximum
  public double dLOG_2Max = 1000.0; // Log Curve 2 Maximum
  public double dLOG_3Max = 1000.0; // Log Curve 3 Maximum
  public double dLOG_4Max = 1000.0; // Log Curve 4 Maximum

  /** Method delete()
   * <p> This method will set the arrays and strings to null to force Java to
   *     deallocate memory
   */

  public void delete()
  {
    sKID       = null; // primary key by KGS db
    sKEY       = null; // Primary Key by user
    sAPI       = null; // API-Number of Well
    sName      = null; // Well Name

    // Other Fields not really displayed

    sCounty    = null; // County Name
    state      = null; // State Name

    // Well Status

    status = null; // Status of Well

    // Rock Data

    depths = null; // Array of Depth Data Values

    dGR    = null; // Array of Gamma Ray Values
    dCGR   = null; // Array of Gamma Ray minus Uranium Values
    dPGR   = null; // Array of Pseudo Gamma Ray Values

    // Density Data

    dGMCC  = null; // Array of Grain Density (gm/cc) Values
    dRHOD  = null; // Array of Density of Rock Dry (gm/cc) Values
    dRHOW  = null; // Array of Density of Rock Wet (gm/cc) Values

    // Porosity Data

    dPCORE = null; // Array of Porosity whole routine (PU) Values
    dPPLUG = null; // Array of Porosity Plug routine (PU) Values
    dP800  = null; // Array of Porosity Plug 800 PSI (PU) Values
    dPINSI = null; // Array of Porosity Plug Insitu (PU) Values
    dPEFF  = null; // Array of Effective Rock Porosity (PU) Values

    // Spectral Gamma Ray Data

    dTh    = null; // Array of Thorium Values
    dU     = null; // Array of Uranium Values
    dK     = null; // Array of Potassium Values

    // Spectral Gamma Ray Lithology Curves

    dThU   = null; // Array of Th/U Ratio Values
    dThK   = null; // Array of Th/K Ratio Values

    // -- Lithology Data

    dGRL   = null; // Array of Gamma Ray Values
    dPHI   = null; // Array of Porosity Values
    dRHOG  = null; // Array of "Grain" Density Values

    // -- Unknown Linear Curves

    dLIN_1 = null; // Linear Curve 1
    dLIN_2 = null; // Linear Curve 2
    dLIN_3 = null; // Linear Curve 3
    dLIN_4 = null; // Linear Curve 4

    // -- Unknown Log Curves

    dLOG_1 = null; // Log Curve 1
    dLOG_2 = null; // Log Curve 2
    dLOG_3 = null; // Log Curve 3
    dLOG_4 = null; // Log Curve 4
  }

  /** Method checkData(int iCurve)
   * <p> This method will check to see if the curve data is present
   * @param  iCurve = the requested curve type
   * @return bvalue = true data exist, false data does not exist
   */

  public boolean checkData(int iCurve)
  {
    boolean bValue = false;
    int     data   = -1;

    switch (iCurve)
    {
      case rock.rockStandardTools._GR:
        data = iGR;
        break;
      case rock.rockStandardTools._CGR:
        data = iCGR;
        break;
      case rock.rockStandardTools._PGR:
        data = iPGR;
        break;

      case rock.rockStandardTools._GMCC:
        data = iGMCC;
        break;
      case rock.rockStandardTools._RHOD:
        data = iRHOD;
        break;
      case rock.rockStandardTools._RHOW:
        data = iRHOW;
        break;

      case rock.rockStandardTools._PCORE:
        data = iPCORE;
        break;
      case rock.rockStandardTools._PPLUG:
        data = iPPLUG;
        break;
      case rock.rockStandardTools._P800:
        data = iP800;
        break;
      case rock.rockStandardTools._PINSI:
        data = iPINSI;
        break;
      case rock.rockStandardTools._PEFF:
        data = iPEFF;
        break;

      case rock.rockStandardTools._TH:
        data = iTh;
        break;
      case rock.rockStandardTools._U:
        data = iU;
        break;
      case rock.rockStandardTools._K:
        data = iK;
        break;

      case rock.rockStandardTools._THU:
        data = iThU;
        break;
      case rock.rockStandardTools._THK:
        data = iThK;
        break;

      case rock.rockStandardTools._GRL:
        data = iGRL;
        break;
      case rock.rockStandardTools._RHOG:
        data = iRHOG;
        break;
      case rock.rockStandardTools._PHI:
        data = iPHI;
        break;

      // Unknown Linear Curves

      case rock.rockStandardTools._LIN_1:
        data = iLIN_1;
        break;
      case rock.rockStandardTools._LIN_2:
        data = iLIN_2;
        break;
      case rock.rockStandardTools._LIN_3:
        data = iLIN_3;
        break;
      case rock.rockStandardTools._LIN_4:
        data = iLIN_4;
        break;

      // Unknown Log Curves

      case rock.rockStandardTools._LOG_1:
        data = iLOG_1;
        break;
      case rock.rockStandardTools._LOG_2:
        data = iLOG_2;
        break;
      case rock.rockStandardTools._LOG_3:
        data = iLOG_3;
        break;
      case rock.rockStandardTools._LOG_4:
        data = iLOG_4;
        break;
    }

    if (data > -1)
      bValue = true;

    return (bValue);
  }

  /** Method getDataCount(int iCurve)
   * <p> This method will return the number of curve data
   * @param  iCurve = the requested curve type
   * @return iValue = total number of curves
   */

  public int getDataCount(int iCurve)
  {
    int iValue = 0;
    int data   = -1;

    switch (iCurve)
    {
      case rock.rockStandardTools._GR:
        data = iGR;
        break;
      case rock.rockStandardTools._CGR:
        data = iCGR;
        break;
      case rock.rockStandardTools._PGR:
        data = iPGR;
        break;

      case rock.rockStandardTools._GMCC:
        data = iGMCC;
        break;
      case rock.rockStandardTools._RHOD:
        data = iRHOD;
        break;
      case rock.rockStandardTools._RHOW:
        data = iRHOW;
        break;

      case rock.rockStandardTools._PCORE:
        data = iPCORE;
        break;
      case rock.rockStandardTools._PPLUG:
        data = iPPLUG;
        break;
      case rock.rockStandardTools._P800:
        data = iP800;
        break;
      case rock.rockStandardTools._PINSI:
        data = iPINSI;
        break;
      case rock.rockStandardTools._PEFF:
        data = iPEFF;
        break;

      case rock.rockStandardTools._TH:
        data = iTh;
        break;
      case rock.rockStandardTools._U:
        data = iU;
        break;
      case rock.rockStandardTools._K:
        data = iK;
        break;

      case rock.rockStandardTools._THU:
        data = iThU;
        break;
      case rock.rockStandardTools._THK:
        data = iThK;
        break;

      case rock.rockStandardTools._GRL:
        data = iGRL;
        break;
      case rock.rockStandardTools._RHOG:
        data = iRHOG;
        break;
      case rock.rockStandardTools._PHI:
        data = iPHI;
        break;

      // Unknown Linear Curves

      case rock.rockStandardTools._LIN_1:
        data = iLIN_1;
        break;
      case rock.rockStandardTools._LIN_2:
        data = iLIN_2;
        break;
      case rock.rockStandardTools._LIN_3:
        data = iLIN_3;
        break;
      case rock.rockStandardTools._LIN_4:
        data = iLIN_4;
        break;

      // Unknown Log Curves

      case rock.rockStandardTools._LOG_1:
        data = iLOG_1;
        break;
      case rock.rockStandardTools._LOG_2:
        data = iLOG_2;
        break;
      case rock.rockStandardTools._LOG_3:
        data = iLOG_3;
        break;
      case rock.rockStandardTools._LOG_4:
        data = iLOG_4;
        break;
    }

    if (data > -1)
      iValue = data;
    else
      iValue = 0;

    return (iValue);
  }

  /** Method getData(int iCurve)
   * <p> This method will retrive the curve data requested
   * @param  iCurve = the requested curve type
   * @return data   = the data requested.
   */

  public double[] getData(int iCurve)
  {
    double data[] = null;

    if (iRows > 0)
    {
      data = new double[iRows];

      switch (iCurve)
      {
        case rock.rockStandardTools._GR:
          data = dGR;
          break;
        case rock.rockStandardTools._CGR:
          data = dCGR;
          break;
        case rock.rockStandardTools._PGR:
          data = dPGR;
          break;

        case rock.rockStandardTools._GMCC:
          data = dGMCC;
          break;
        case rock.rockStandardTools._RHOD:
          data = dRHOD;
          break;
        case rock.rockStandardTools._RHOW:
          data = dRHOW;
          break;

        case rock.rockStandardTools._PCORE:
          data = dPCORE;
          break;
        case rock.rockStandardTools._PPLUG:
          data = dPPLUG;
          break;
        case rock.rockStandardTools._P800:
          data = dP800;
          break;
        case rock.rockStandardTools._PINSI:
          data = dPINSI;
          break;
        case rock.rockStandardTools._PEFF:
          data = dPEFF;
          break;

        case rock.rockStandardTools._TH:
          data = dTh;
          break;
        case rock.rockStandardTools._U:
          data = dU;
          break;
        case rock.rockStandardTools._K:
          data = dK;
          break;

        case rock.rockStandardTools._THU:
          data = dThU;
          break;
        case rock.rockStandardTools._THK:
          data = dThK;
          break;

        case rock.rockStandardTools._GRL:
          data = dGRL;
          break;
        case rock.rockStandardTools._RHOG:
          data = dRHOG;
          break;
        case rock.rockStandardTools._PHI:
          data = dPHI;
          break;

        // Unknown Linear Curves

        case rock.rockStandardTools._LIN_1:
          data = dLIN_1;
          break;
        case rock.rockStandardTools._LIN_2:
          data = dLIN_2;
          break;
        case rock.rockStandardTools._LIN_3:
          data = dLIN_3;
          break;
        case rock.rockStandardTools._LIN_4:
          data = dLIN_4;
          break;

        // Unknown Log Curves

        case rock.rockStandardTools._LOG_1:
          data = dLOG_1;
          break;
        case rock.rockStandardTools._LOG_2:
          data = dLOG_2;
          break;
        case rock.rockStandardTools._LOG_3:
          data = dLOG_3;
          break;
        case rock.rockStandardTools._LOG_4:
          data = dLOG_4;
          break;
      }
    }

    return (data);
  }
}