/*
 * @rockDataStruct.java Version 1.1 11/06/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock;

/** CLASS rockDataStruct
 *  <p> This Class holds the Rock Data Information.
 *
 *  @version 1.1 11/06/2007
 *  @author  John R. Victorine
 */

public class rockDataStruct
{
  public static final double dNULL = -999.95; // Null Value for an empty data set

  // Primary Keys for identification of each record

  public String sKID   = "0";   // Primary KEY of Record
  public String sKEY   = "0";   // User defined Primary KEY of Record

  public String sProprietary = "Y";  // Proprietary data

  // Descriptive fields to define rock

  public String sUNIT  = "";    // Stratigraphic Unit
  public String sNAME  = "";    // Stratigraphic Name
  public String sENV   = "";    // DEPOSITIONAL_ENVIRONMENT
  public String sLITHO = "";    // LITHOFACIES

  // Depth information

  public double dTOP   = dNULL;   // Depth Top of Rock (ft)
  public double dBASE  = dNULL;   // Depth Base of Rock (ft)
//  public double dCORR  = dNULL;   // Correction added to depth (ft)
  public double dCORR  = 0.0;     // Correction added to depth (ft)

  // Porosity Data

  public double dPCORE = dNULL;   // Porosity whole routine (PU)
  public double dPPLUG = dNULL;   // Porosity Plug routine (PU)
  public double dP800  = dNULL;   // Porosity Plug 800 PSI (PU)
  public double dPINSI = dNULL;   // Porosity Plug Insitu (PU)
  public double dPEFF  = dNULL;   // Effective Rock Porosity (PU)

  // Permeability Data

  public double dKMAX  = dNULL;   // Permeability Whole Max (md)
  public double dK90   = dNULL;   // Permeability Whole 90 (md)
  public double dKVRT  = dNULL;   // Permeability Whole Vertical (md)
  public double dKPLG  = dNULL;   // Permeability Plug Routine (md)
  public double dKKL   = dNULL;   // Permeability Plug Klinkenberg Routine (md)
  public double dKINSI = dNULL;   // Permeability Plug Insitu (md)
  public double dKKLIN = dNULL;   // Permeability Plug Klinkenberg Insitu (md)
  public double dKPVRT = dNULL;   // Permeability Plug Vertical (md)

  // Saturation Data

  public double dSOIL  = dNULL;   // Saturation Oil (%)
  public double dSW    = dNULL;   // Saturation Water (%)

  // Density Data

  public double dGMCC  = dNULL;   // Grain Density (gm/cc)
  public double dRHOD  = dNULL;   // Density of Rock Dry (gm/cc)
  public double dRHOW  = dNULL;   // Density of Rock Wet (gm/cc)

  // Archie Constants

  public double dMAMB  = dNULL;   // Archie Cementation (M) Ambient
  public double dMINSI = dNULL;   // Archie Cementation (M) Insitu
  public double dNAMB  = dNULL;   // Archie Saturation (N) Ambient
  public double dNINSI = dNULL;   // Archie Saturation (N) Insitu

  // Measured Gamma Ray Data

  public double dGR    = dNULL;   // Gamma Ray Value
  public double dCGR   = dNULL;   // Gamma Ray minus Uranimum Value
  public double dPGR   = dNULL;   // Pseudo Gamma Ray Value

  public double dTh    = dNULL;   // Thorium Values
  public double dU     = dNULL;   // Uranium Values
  public double dK     = dNULL;   // Potassium Values

  // -- Unknown Linear Curves

  public double dLIN_1 = dNULL;   // Linear Curve 1
  public double dLIN_2 = dNULL;   // Linear Curve 2
  public double dLIN_3 = dNULL;   // Linear Curve 3
  public double dLIN_4 = dNULL;   // Linear Curve 4

  // -- Unknown Log Curves

  public double dLOG_1 = dNULL;   // Log Curve 1
  public double dLOG_2 = dNULL;   // Log Curve 2
  public double dLOG_3 = dNULL;   // Log Curve 3
  public double dLOG_4 = dNULL;   // Log Curve 4

  // misc data

  public int    iLITH_CD  = 0;  // Lithofacies Code
  public String sFracture = ""; // Fractures

  public String source    = ""; // source
  public String sDate     = ""; // date of data
  public String sComments = ""; // Comments

  // Computed Curves for building Lithology

  public double dRHOB = dNULL;
  public double dNPHI = dNULL;

  /** Method delete()
   * <p> This method will force set the Objects to null and force Java to
   *     free unwanted memory
   */

  public void delete()
  {
    sKID      = null;    // Primary KEY of Record
    sKEY      = null;    // User defined primary key
    sProprietary = null;
    sUNIT     = null;    // Stratigraphic Unit
    sNAME     = null;    // Stratigraphic Name
    sENV      = null;    // DEPOSITIONAL_ENVIRONMENT
    sLITHO    = null;    // LITHOFACIES
    sFracture = null;    // Fractures
    source    = null;    // source
    sDate     = null;    // date of data
    sComments = null;    // Comments
  }

  public void print()
  {
    // Primary Keys for identification of each record
    System.out.println("KID: "+sKID+" KEY: "+sKEY+" PUBLIC: "+ sProprietary);

    // Descriptive fields to define rock

    if ((sUNIT.length() > 0) || (sNAME.length() > 0) ||
        (sENV.length() > 0)  || (sLITHO.length() > 0))
    {
      if (sUNIT.length() > 0) System.out.println(" Stratigraphic Unit: " + sUNIT);
      if (sNAME.length() > 0) System.out.println(" Stratigraphic Name: " + sNAME);
      if (sENV.length() > 0)  System.out.println(" Environment: " + sENV);
      if (sLITHO.length() > 0) System.out.println(" Lithofacies : " + sLITHO);
    }

    // Depth information

    System.out.println("Top: "+dTOP+" Base: "+dBASE+" Correction: "+ dCORR);

    // Porosity Data

    if ((dPCORE != dNULL) || (dPPLUG != dNULL) ||
        (dP800 != dNULL) || (dPINSI != dNULL) || (dPEFF != dNULL))
    {
      System.out.print("Porosity ");
      if (dPCORE != dNULL) System.out.print(" PCORE: " + dPCORE);
      if (dPPLUG != dNULL) System.out.print(" PPLUG: " + dPPLUG);
      if (dP800 != dNULL)  System.out.print(" P800: "  + dP800);
      if (dPINSI != dNULL) System.out.print(" PINSI: " + dPINSI);
      if (dPEFF != dNULL)  System.out.print(" PEFF: "  + dPEFF);
      System.out.println("");
    }

    // Permeability Data

    if ((dKMAX  != dNULL) || (dK90   != dNULL) || (dKVRT  != dNULL) ||
        (dKPLG  != dNULL) || (dKKL   != dNULL) || (dKINSI != dNULL) ||
        (dKKLIN != dNULL) || (dKPVRT != dNULL))
    {
      System.out.print("Permeability ");
      if (dKMAX  != dNULL) System.out.print(" KMAX: "  + dKMAX);
      if (dK90   != dNULL) System.out.print(" K90: "   + dK90);
      if (dKVRT  != dNULL) System.out.print(" KVRT: "  + dKVRT);
      if (dKPLG  != dNULL) System.out.print(" KPLG: "  + dKPLG);
      if (dKKL   != dNULL) System.out.print(" KKL: "   + dKKL);
      if (dKINSI != dNULL) System.out.print(" KINSI: " + dKINSI);
      if (dKKLIN != dNULL) System.out.print(" KKLIN: " + dKKLIN);
      if (dKPVRT != dNULL) System.out.print(" KPVRT: " + dKPVRT);
      System.out.println("");
    }

    // Saturation Data

    if ((dSOIL != dNULL) || (dSW != dNULL))
    {
      System.out.print("Saturation ");
      if (dSOIL != dNULL) System.out.print(" SOIL: " + dSOIL);
      if (dSW   != dNULL) System.out.print(" SW: "   + dSW);
      System.out.println("");
    }

    // Density Data

    if ((dGMCC != dNULL) || (dRHOD != dNULL) || (dRHOW != dNULL))
    {
      System.out.print("Density ");
      if (dGMCC != dNULL) System.out.print(" GMCC: " + dGMCC);
      if (dRHOD != dNULL) System.out.print(" RHOD: " + dRHOD);
      if (dRHOW != dNULL) System.out.print(" RHOW: " + dRHOW);
      System.out.println("");
    }

    // Archie Constants

    if ((dMAMB != dNULL) || (dMINSI != dNULL) || (dNAMB != dNULL) || (dNINSI != dNULL) )
    {
      System.out.print("Archie Constants ");
      if (dMAMB  != dNULL) System.out.print(" MAMB: "  + dMAMB);
      if (dMINSI != dNULL) System.out.print(" MINSI: " + dMINSI);
      if (dNAMB  != dNULL) System.out.print(" NAMB: "  + dNAMB);
      if (dNINSI != dNULL) System.out.print(" NINSI: " + dNINSI);
      System.out.println("");
    }

    if ((dRHOB != dNULL) || (dNPHI != dNULL))
    {
      System.out.println(" dRHOB: " + dRHOB + " dNPHI: " + dNPHI);
    }

    // misc data

    if ((iLITH_CD != 0) || (sFracture.length() > 0))
    {
      if (iLITH_CD != 0) System.out.print("LITH Code: " + iLITH_CD);
      if (sFracture.length() > 0) System.out.print(" Fractures: " + sFracture);
      System.out.println("");
    }

    if ((source.length() > 0) || (sDate.length() > 0) || (sComments.length() > 0))
    {
      if (source.length() > 0) System.out.print("Source: " + source);
      if (sDate.length() > 0) System.out.print(" Date: " + sDate);
      System.out.println("");
      if (sComments.length() > 0) System.out.println("Comments: " + sComments);
    }
  }
}
