/*
 * @phiPlotSymbol.java Version 1.1 09/04/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.phi.plot;

import java.awt.*;
import java.awt.geom.*;
import java.util.Observable;
import java.awt.event.*;

import mask.maskSymbolsListStruct;
import mask.plot.maskPlotSymbol;
import rock.phi.phiStruct;

/** Class phiPlotSymbol
 *  <p> This method will create the different symbol types for plotting data
 *      values on a plot.
 *
 *  @version 1.1 09/04/2008
 *  @author  John R. Victorine
 */

public class phiPlotSymbol extends Canvas implements MouseListener
{
  private Observable            notifier  = null; // Observable Object
  private maskSymbolsListStruct stSymbols = null; // Porosity Type Symbols
  private maskPlotSymbol        plot      = null; // Plot Mask Symbol

  private static final int NO  = 0;
  private static final int YES = 1;

  private static final int _NONE      = -1;
//  private static final int _PRIMARY   = 0;
//  private static final int _SECONDARY = 1;

  private phiStruct st          = null;
  private int       iSelected[] = null; //{ -1, -1 };
  private int       iWidth      = 300;
  private int       iHeight     = 300;

  private static final int _START       = 10;
  private static final int _FIRST       = 10;
  private static final int _SECOND      = 25;
  private static final int _IMAGE_START = 40;//90;
  private static final int _DESC_START  = 55;//105;
  private static final int _DESCRIPTION = 63;//115;
  private static final int _SEP         = 15;

  /** CONSTRUCTOR phiPlotSymbol()
   *  <p> This is the constructor for this class.
   *  @param notifier  = Observable
   *  @param stSymbols = Porosity Types Plot Symbols List Data Structure
   */

  public phiPlotSymbol( Observable notifier, maskSymbolsListStruct stSymbols )
  {
    this.notifier = notifier;
    this.stSymbols = stSymbols;

    if (stSymbols.iCount > 0)
    {
      iSelected = new int[stSymbols.iCount];
      for (int i=0; i<stSymbols.iCount; i++)
        iSelected[i] = NO;
    }

    plot = new maskPlotSymbol( stSymbols );

    this.setBackground(Color.white);
    addMouseListener(this);
  }

  /** Method close()
   * <p> This method will force Java to deallocate memory
   */

  public void close()
  {
    notifier  = null;
    stSymbols = null;

    if (plot != null)
      plot.close();
    plot = null;

    st        = null;
    iSelected = null;
  }

  /* =============================================================== *
   * ------------------------- GET METHODS ------------------------- *
   * =============================================================== */

  /** Method getPlotWidth()
   * <p> This method will return the Width of the plot panel.
   * @return WIDTH = the width of the plot panel
   */

  public int getPlotWidth() { return (iWidth); }

  /** Method getPlotHeight()
   * <p> This method will return the Width of the plot panel.
   * @return the height of the plot panel
   */

  public int getPlotHeight() { return (iHeight); }

  /** Method getData()
   * <p> This method will get the array of porosity selected
   * @return st = porosity data Structure
   */

  public phiStruct getData() { return (st); }

  /* =============================================================== *
   * ------------------------- SET METHODS ------------------------- *
   * =============================================================== */

  /** Method setData()
   * <p> This method will set the array of porosity selected
   * @param st = porosity data Structure
   */

  public void setData(phiStruct st)
  {
    this.st = st;

//    iSelected[_PRIMARY]   = _NONE;
//    iSelected[_SECONDARY] = _NONE;

    for (int i=0; i<stSymbols.iCount; i++)
    {
      iSelected[i] = NO;
    }

    for (int i=0; i<stSymbols.iCount; i++)
    {
      if (st != null)
      {
        for (int j=0; j<st.iTotal; j++)
        {
          if (st.sID[j].equals(stSymbols.stItem[i].sID))
          {
			iSelected[i] = YES;
//            if (st.sType[j].equals("Primary"))
//              iSelected[_PRIMARY] = i;
//            else if (st.sType[j].equals("Secondary"))
//              iSelected[_SECONDARY] = i;
          }
        }
      }
    }

    repaint();
  }

  /* =============================================================== *
   * ------------------------ MISC METHODS ------------------------- *
   * =============================================================== */

  /** Method togglePHI()
   * <p> This method will toggle a porosity from one state to the other.
   * @param iPHI  = the porosity number to toggle.
   * @param iType = type of porosity
   *

  private void togglePHI(int iPHI, int iType) { iSelected[iType] = iPHI; }
*/
  /** Method togglePHI()
   * <p> This method will toggle a porosity type from one state to the other.
   * @param iPHI = the porosity type number to toggle.
   */

  private void togglePHI(int iPHI)
  {
    if (iSelected[iPHI] == NO)
      iSelected[iPHI] = YES;
    else
      iSelected[iPHI] = NO;
  }

  /** Method modifyPHIList()
   * <p> This method will check add or remove porosity from the porosity list
   *     depending if it is selected
   */

  private void modifyPHIList()
  {
    int i      = 0;
    int iCount = 0;

    if (st == null)
    {
      st = new phiStruct();
      st.sKEY = new String(cmn.cmnString.UniqueName());
    }

//    for (i=0; i<2; i++)
    for (i=0; i<iSelected.length; i++)
    {
//      if (iSelected[i] > -1)
      if (iSelected[i] == YES)
        iCount++;
    }

    st.iTotal = 0;
    st.sID    = null;
    st.sType  = null;
    st.sText  = null;

    if (iCount > 0)
    {
      st.iTotal = iCount;
      st.sID    = new String[iCount];
      st.sType  = new String[iCount];
      st.sText  = new String[iCount];

      iCount = 0;
      for (i=0; i<iSelected.length; i++)
      {
        if (iSelected[i] == YES)
        {
          if (iCount < st.iTotal)
          {
            st.sID[iCount]   = new String(stSymbols.stItem[i].sID);
            st.sText[iCount] = new String(stSymbols.stItem[i].sName);
            st.sType[iCount] = new String("");
//            st.sID[iCount]   = new String(stSymbols.stItem[iSelected[i]].sID);
//            st.sText[iCount] = new String(stSymbols.stItem[iSelected[i]].sName);
            iCount++;
          }
	    }
	  }
/*
      for (i=0; i<2; i++)
      {
        if (iSelected[i] > -1)
        {
          if (iCount < st.iTotal)
          {
            st.sID[iCount]   = new String(stSymbols.stItem[iSelected[i]].sID);

            if (i==0)
              st.sType[iCount] = new String("Primary");
            else if (i==1)
              st.sType[iCount] = new String("Secondary");

            st.sText[iCount] = new String(stSymbols.stItem[iSelected[i]].sName);
            iCount++;
          }
        }
      }
*/
    }
    else
    {
      st.iTotal = 0;
      st.sID    = null;
      st.sType  = null;
      st.sText  = null;
    }
  }

  /* =============================================================== *
   * -------------------- MouseListener Methods -------------------- *
   * =============================================================== */

  public void mouseMoved(MouseEvent event) { }
  public void mouseEntered(MouseEvent event) { }
  public void mouseExited(MouseEvent event) { }
  public void mousePressed(MouseEvent event) { }
  public void mouseDragged(MouseEvent event) {}
  public void mouseReleased(MouseEvent event) {}

  /** Method mouseClicked()
   *  <p> Mouse Clicked Method retrieve the location of the mouse pointer
   *      location.
   * @param event - Mouse Clicked Event
   */

  public void mouseClicked(MouseEvent event)
  {
    int    iXm     = event.getX();
    int    iYm     = event.getY();

    for (int i=0; i<stSymbols.iCount; i++)
    {
      if ((iYm >= _START + (i+1)*_SEP) && (iYm < _START + (i+2)*_SEP))
      {
	    togglePHI(i);
      }
    }
/*
    if ((iYm >= _START) && (iYm < _START + _SEP))
    {
      if (iXm < _SECOND)
      {
        togglePHI(_NONE, _PRIMARY);
      }
      else if (iXm < _IMAGE_START)
      {
        togglePHI(_NONE, _SECONDARY);
      }
    }

    for (int i=0; i<stSymbols.iCount; i++)
    {
      if ((iYm >= _START + (i+1)*_SEP) && (iYm < _START + (i+2)*_SEP))
      {
        if (iXm < _SECOND)
        {
          togglePHI(i, _PRIMARY);
        }
        else if (iXm < _IMAGE_START)
        {
          togglePHI(i, _SECONDARY);
        }
      }
    }
*/

    modifyPHIList();
    repaint();

    notifier.notifyObservers(new String("Rock Porosity Changed"));
  }

  /* ======================================================================== *
   * ------------------------------- PAINT ---------------------------------- *
   * ======================================================================== */

  /** Method draw()
   * <p> This method will draw the porosity image panels
   * @param g - Graphics Parameter.
   */

  public void draw(Graphics g)
  {
    Font        fsb   = new Font("Serif", Font.BOLD, 12);
    FontMetrics fsbm  = g.getFontMetrics(fsb);
    g.setFont( fsb );
/*
    if (notifier != null)
    {
      g.setColor(Color.red);
      if (iSelected[0] == -1)
      {
        g.drawLine(_FIRST,       _START, _FIRST + 10,  _START + 10);
        g.drawLine(_FIRST + 10,  _START, _FIRST,       _START + 10);
      }

      if (iSelected[1] == -1)
      {
        g.drawLine(_SECOND,      _START, _SECOND + 10, _START + 10);
        g.drawLine(_SECOND + 10, _START, _SECOND,      _START + 10);
      }

      g.setColor(Color.black);
      g.drawRect(_FIRST,  _START, 10, 10);
      g.drawRect(_SECOND, _START, 10, 10);
    }
*/
    for (int i=0; i<stSymbols.iCount; i++)
    {
      if (notifier != null)
      {
        g.setColor(Color.red);
        if (iSelected[i] == YES)//if (iSelected[0] == i)
        {
          g.drawLine( _FIRST,      _START + (i+1)*_SEP,
                      _FIRST + 10, _START + (i+1)*_SEP + 10 );
          g.drawLine( _FIRST + 10, _START + (i+1)*_SEP,
                      _FIRST,      _START + (i+1)*_SEP + 10 );
        }

//        if (iSelected[1] == i)
//        {
//          g.drawLine( _SECOND,      _START + (i+1)*_SEP,
//                      _SECOND + 10, _START + (i+1)*_SEP + 10 );
//          g.drawLine( _SECOND + 10, _START + (i+1)*_SEP,
//                      _SECOND,      _START + (i+1)*_SEP + 10 );
//        }

        g.setColor(Color.black);
        g.drawRect(_FIRST,  _START + (i+1)*_SEP, 10, 10);
//        g.drawRect(_SECOND, _START + (i+1)*_SEP, 10, 10);
      }

      g.setColor(Color.black);
      g.drawLine(_DESC_START,   _START+(i+1)*_SEP+6,
                 _DESC_START+5, _START+(i+1)*_SEP+6);
      g.drawString( stSymbols.stItem[i].sName,
                    _DESCRIPTION, _START + (i+1)*_SEP + 8);

      plot.drawSymbol(
            g, stSymbols.stItem[i].iRows, 0,
            stSymbols.stItem[i].symbol,
            _IMAGE_START, _START + (i+1)*_SEP );
    }
  }

  /** Method paint(Graphics g)
   * <p> This method will paint Porosity & Permeability Plot
   * @param g - Graphics Parameter.
   */

  public void paint(Graphics g)
  {
    g.setColor(Color.white);
    g.fillRect(0, 0, iWidth, iHeight);

    draw(g);
  }
}

/*
 *  @version 1.1 09/04/2008
 *  @author  John Victorine
 */
