/*
 * @phiPlotLegendBuffered.java Version 1.1 03/10/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.phi.plot;

import java.awt.*;
import java.awt.image.*;

import rock.phi.plot.phiPlotLegend;

/** Class phiPlotLegendBuffered
 *  <p> This Class will create a buffered image.
 *
 *  @version 1.1 03/10/2009
 *  @author  John R. Victorine
 */

import mask.maskSymbolsListStruct;

public class phiPlotLegendBuffered
{
  /** Method makePlotImage( int iSelected[] )
   *  This method will plot well profile data.  The plot is then converted to
   *  an buffered image and passed back to the calling routine.
   *  @param  iSelected = The Porisity Type Symbols selected
   *  @return image     = Fossil Symbols plot buffered image
   */

  public static BufferedImage makePlotImage( int iSelected[],
                                             maskSymbolsListStruct stSymbols )
  {
    BufferedImage image    = null;
    phiPlotLegend plot     = null;
    int           iWidth   = 0;
    int           iHeight  = 0;

    plot    = new phiPlotLegend( iSelected, stSymbols );
    iWidth  = plot.getPlotWidth();
    iHeight = plot.getPlotHeight();

    // Build Buffered Image

    image = new BufferedImage(iWidth, iHeight, BufferedImage.TYPE_INT_RGB);

    Graphics graphics = image.getGraphics();

    graphics.setColor(Color.white);
    graphics.fillRect(0, 0, iWidth, iHeight);

    plot.draw(graphics);

    graphics.dispose();

    return (image);
  }
}