/*
 * @phiPlotLegend.java Version 1.1 03/10/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.phi.plot;

import java.awt.*;
import java.awt.geom.*;
import java.util.Observable;
import java.awt.event.*;

import mask.maskSymbolsListStruct;
import mask.plot.maskPlotSymbol;
import rock.phi.phiStruct;

/** Class phiPlotLegend
 *  <p> This method will create the different symbol types for plotting data
 *      values on a plot.
 *
 *  @version 1.1 03/10/2009
 *  @author  John R. Victorine
 */

public class phiPlotLegend extends Canvas
{
  private int                   iSelected[] = null; // Selected Types
  private maskSymbolsListStruct stSymbols   = null; // Porosity Type Symbols
  private maskPlotSymbol        plot        = null; // Plot Mask Symbol

  private int       iWidth      = 300;
  private int       iHeight     = 300;

  private static final int _START       = 10;
  private static final int _IMAGE_START = 10;
  private static final int _DESC_START  = 25;
  private static final int _DESCRIPTION = 33;
  private static final int _SEP         = 15;

  /** CONSTRUCTOR phiPlotLegend( int iSelected[],
   *                             maskSymbolsListStruct stSymbols )
   *  <p> This is the constructor for this class.
   *  @param iSelected = The Porisity Type Symbols selected
   *  @param stSymbols = Porosity Types Plot Symbols List Data Structure
   */

  public phiPlotLegend( int iSelected[], maskSymbolsListStruct stSymbols )
  {
    int iCount = 0;

    this.iSelected = iSelected;
    if (iSelected != null)
    {
      for (int i=0; i<iSelected.length; i++)
      {
        if (iSelected[i] == 0)
          iCount++;
      }
    }

    this.stSymbols = stSymbols;
    plot = new maskPlotSymbol( stSymbols );

    iHeight = 30 + _SEP * iCount;
  }

  /** Method close()
   * <p> This method will force Java to deallocate memory
   */

  public void close()
  {
    iSelected = null;
    stSymbols = null;

    if (plot != null)
      plot.close();
    plot = null;
  }

  /* =============================================================== *
   * ------------------------- GET METHODS ------------------------- *
   * =============================================================== */

  /** Method getPlotWidth()
   * <p> This method will return the Width of the plot panel.
   * @return WIDTH = the width of the plot panel
   */

  public int getPlotWidth() { return (iWidth); }

  /** Method getPlotHeight()
   * <p> This method will return the Width of the plot panel.
   * @return the height of the plot panel
   */

  public int getPlotHeight() { return (iHeight); }

  /* ======================================================================== *
   * ------------------------------- PAINT ---------------------------------- *
   * ======================================================================== */

  /** Method draw()
   * <p> This method will draw the porosity image panels
   * @param g - Graphics Parameter.
   */

  public void draw(Graphics g)
  {
    int         iStart = _START;
    int         iLen   = 0;
    int         iCount = 0;
    String      sText  = "";
    Font        fsb    = new Font("Serif", Font.BOLD, 12);
    FontMetrics fsbm   = g.getFontMetrics(fsb);

    g.setFont( fsb );
    g.setColor( Color.black );

    sText = new String( "Porosity Type" );
    iLen  = sText.length();

    g.drawString( sText, iWidth/2 - 4*iLen, iStart);

    iStart = iStart + _SEP;

    for (int i=0; i<stSymbols.iCount; i++)
    {
      if (iSelected != null)
      {
        if (iSelected[i] == 0)
        {
          g.setColor(Color.black);
          g.drawLine( _DESC_START, iStart + iCount * _SEP + 6,
                      _DESC_START + 5, iStart + iCount * _SEP + 6);
          g.drawString( stSymbols.stItem[i].sName,
                        _DESCRIPTION, iStart + iCount * _SEP + 8);

          plot.drawSymbol(
                g, stSymbols.stItem[i].iRows, 0,
                stSymbols.stItem[i].symbol,
                _IMAGE_START, iStart + iCount * _SEP );

          iCount++;
        }
      }
    }
  }

  /** Method paint(Graphics g)
   * <p> This method will paint Porosity & Permeability Plot
   * @param g - Graphics Parameter.
   */

  public void paint(Graphics g)
  {
    g.setColor(Color.white);
    g.fillRect(0, 0, iWidth, iHeight);

    draw(g);
  }
}

/*
 *  @version 1.1 03/10/2009
 *  @author  John Victorine
 */
