/*
 * @phiPlotDataEntry.java Version 1.1 09/26/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.phi.plot;

import java.awt.*;
import java.awt.geom.*;

import mask.maskSymbolsListStruct;
import mask.plot.maskPlotSymbol;
import rock.phi.phiStruct;

/** Class phiPlotDataEntry
 *  <p> This method will display the porosity selected
 *
 *  @version 1.1 09/26/2008
 *  @author  John R. Victorine
 */

public class phiPlotDataEntry extends Canvas
{
  private static final int NO  = 0;
  private static final int YES = 1;

  private maskSymbolsListStruct stSymbols = null; // Porosity Type Symbols
  private maskPlotSymbol        plot      = null; // Plot Mask Symbol
  private phiStruct             st        = null;

  private int iWidth  = 100;
  private int iHeight = 35;

  private static final int _START       = 5;//10;
  private static final int _IMAGE_START = 5;//20;
  private static final int _DESC_START  = 20;//55;
  private static final int _DESCRIPTION = 30;//65;
  private static final int _SEP         = 15;

  /** CONSTRUCTOR phiPlotDataEntry( maskSymbolsListStruct stSymbols )
   *  <p> This is the constructor for this class.
   *  @param stSymbols = Porosity Types Plot Symbols List Data Structure
   */

  public phiPlotDataEntry( maskSymbolsListStruct stSymbols )
  {
    this.stSymbols = stSymbols;
    plot = new maskPlotSymbol( stSymbols );
  }

  /** Method close()
   * <p> This method will force Java to deallocate memory
   */

  public void close()
  {
    stSymbols = null;

    if (plot != null)
      plot.close();
    plot = null;

    if (st != null)
      st.delete();
    st = null;
  }

  /* =============================================================== *
   * ------------------------- GET METHODS ------------------------- *
   * =============================================================== */

  /** Method getPlotWidth()
   * <p> This method will return the Width of the plot panel.
   * @return WIDTH = the width of the plot panel
   */

  public int getPlotWidth() { return (iWidth); }

  /** Method getPlotHeight()
   * <p> This method will return the Width of the plot panel.
   * @return the height of the plot panel
   */

  public int getPlotHeight() { return (iHeight); }

  /** Method getData()
   * <p> This method will get the array of porosity selected
   * @return st = porosity data Structure
   */

  public phiStruct getData() { return (st); }

  /* =============================================================== *
   * ------------------------- SET METHODS ------------------------- *
   * =============================================================== */

  /** Method setData( phiStruct st )
   * <p> This method will set the array of porosity selected
   * @param st = porosity data Structure
   */

  public void setData( phiStruct st )
  {
	int    iFound = -1;
	int    len    = 0;
	String str    = "";

    this.st = st;

    iWidth  = 100;
    iHeight = 35;

    if (st != null)
    {
      iWidth  = 100;
      iHeight = 35;

	  if (st.iTotal > 0)
	  {
	    iHeight = _START + st.iTotal*_SEP;

        for (int i=0; i<st.iTotal; i++)
        {
          iFound = -1;
          for (int j=0; j<stSymbols.iCount; j++)
          {
            if (st.sID[i].equals(stSymbols.stItem[j].sID))
            {
              iFound = j;
            }
          }
          len    = 0;
          str    = "";

          if (iFound > -1)
          {
		    str = new String(stSymbols.stItem[iFound].sName.trim());
            len = _DESCRIPTION + 6 * str.length();
            if (len > iWidth)
              iWidth = len;
          }
        }
      }
    }

    repaint();
  }

  /* ======================================================================== *
   * ------------------------------- PAINT ---------------------------------- *
   * ======================================================================== */

  /** Method draw(Graphics g)
   * <p> This method will draw the porosity image panels
   * @param g - Graphics Parameter.
   */

  public void draw(Graphics g)
  {
    int         iFound = -1;
    Font        fsb    = new Font("Serif", Font.BOLD, 12);
    FontMetrics fsbm   = g.getFontMetrics(fsb);

    g.setFont( fsb );
/*
    if (st != null)
    {
      for (int i=0; i<st.iTotal; i++)
      {
System.out.println(i+" "+st.sID[i]+" "+st.sText[i]);
      }
    }
*/
    if (st != null)
    {
      for (int i=0; i<st.iTotal; i++)
      {
        iFound = -1;
        for (int j=0; j<stSymbols.iCount; j++)
        {
          if (st.sID[i].equals(stSymbols.stItem[j].sID))
          {
            iFound = j;
          }
        }

        if (iFound > -1)
        {
          g.setColor(Color.black);
          g.drawLine(_DESC_START,      _START + i*_SEP + 6,
                     _DESC_START + 5,  _START + i*_SEP + 6);
          g.drawString( stSymbols.stItem[iFound].sName,
                        _DESCRIPTION, _START + i*_SEP + 8);

          plot.drawSymbol(
                g, stSymbols.stItem[iFound].iRows, 0,
                stSymbols.stItem[iFound].symbol,
                _IMAGE_START, _START + i*_SEP );
        }
      }
    }
  }

  /** Method paint(Graphics g)
   * <p> This method will paint Porosity & Permeability Plot
   * @param g - Graphics Parameter.
   */

  public void paint(Graphics g)
  {
    g.setColor(Color.white);
    g.fillRect(0, 0, iWidth, iHeight);

    draw(g);
  }
}