/*
 * @phiStruct.java Version 1.1 09/26/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.phi;

/** Class phiStruct
 *  <p> This Class holds the Rock Porosity Depth Data.
 *
 *  @version 1.1 09/26/2008
 *  @author  John R. Victorine
 */

public class phiStruct
{
  public String sKEY        = "0";
  public double depthStart  = 0.0; // Starting Depth
  public double depthEnd    = 0.0; // Ending Depth

  public double dPHI        = 0.0; // Porosity (%)

  public int    iRockType   = rock.phi.phiLookupStruct._NONE; // Background
  public int    iProcess    = rock.phi.phiLookupStruct._NONE; // Process
  public int    iStage      = rock.phi.phiLookupStruct._NONE; // Stage
  public int    iTime       = rock.phi.phiLookupStruct._NONE; // time
  public int    iSize       = rock.phi.phiLookupStruct._NONE; // Avg Size
  public String sGroup      = ""; // Not Used

  public int    iTotal      = 0;
  public String sID[]       = null;  // Symbol ID
  public String sType[]     = null;  // Type of Porosity, Primary or Secondary
  public String sText[]     = null;  // Symbol Text

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    sKEY         = null;
    sID          = null;
    sType        = null;
    sText        = null;
    sGroup       = null;
  }
}
