/*
 * @phiLookupStruct.java Version 1.1 09/25/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.phi;

/** Class phiLookupStruct
 *  <p> This Class holds the Porosity Image Data.
 *
 *  @version 1.1 09/25/2008
 *  @author  John R. Victorine
 */

public class phiLookupStruct
{
  public static final int _NONE      = -1;

  // Rock Type

  public static final int _MUDSTONE  = 0;
  public static final int _SANDSTONE = 1;
  public static final int _LIMESTONE = 2;
  public static final int _DOLOMITE  = 3;

  public static final String ROCK[] = {
      "Clay/Shale", "Sandstone", "Limestone", "Dolomite" };

  // Process

  public static final int _SOLUTION           = 0;
  public static final int _CEMENTATION        = 1;
  public static final int _INTERNAL_SEDIMENTS = 2;

  public static final String PROCESS[] = {
      "Solution", "Cementation", "Internal Sediment"};

  // Direction or Stage

  public static final int _ENLARGED = 0;
  public static final int _REDUCED  = 1;
  public static final int _FILLED   = 2;

  public static final String STAGE[] = { "Enlarged", "Reduced", "Filled" };

  // Time of Formation

  public static final int _P_PRE_DEPOSITIONAL = 0;
  public static final int _P_DEPOSITIONAL     = 1;
  public static final int _S_EOGENETIC        = 2;
  public static final int _S_MESOGENETIC      = 3;
  public static final int _S_TELOGENETIC      = 4;

  public static final String FORMATION_TIME[][] = {
    { "Primary",   "Pre-depositional" },
    { "Primary",   "Depositional" },
    { "Secondary", "Eogenetic" },
    { "Secondary", "Mesogenetic" },
    { "Secondary", "Telogenetic" },
  };

  public static final int _MEGA_LARGE = 0;
  public static final int _MEGA_SMALL = 1;
  public static final int _MESO_LARGE = 2;
  public static final int _MESO_SMALL = 3;
  public static final int _MICRO      = 4;

  public static final String SIZE[][] = {
  //     Classes            Min(mm) Max(mm)
    { "Megapore",  "Large", "32",   "256" },
    { "Megapore",  "Small",  "4",    "32" },
    { "Mesopore",  "Large",  "0.5",   "4" },
    { "Mesopore",  "Small",  "0.625", "0.5" },
    { "Micropore", "",       "0.0",   "0.625" },
  };

  public static final double _SIZE[][] = {
 // Min (mm) Max (mm)
    { 32,    256 },
    { 4,     32 },
    { 0.5,    4 },
    { 0.625,  0.5 },
    { 0.0,    0.625 },
  };
}