/*
 * @phiPlotSymbolPanel.java Version 1.1 09/29/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.phi.gui;

import java.awt.*;
import java.awt.image.*;
import java.util.Observable;
import javax.swing.*;

import mask.maskSymbolsListStruct;
import rock.phi.plot.phiPlotSymbol;
import rock.phi.phiStruct;

/** Class phiPlotSymbolPanel
 *  <p> This Class will display the phi images available
 *
 *  @version 1.1 09/29/2008
 *  @author  John R. Victorine
 */

public class phiPlotSymbolPanel extends Panel
{
  private JFrame                parent    = null; // Frame callint this panel
  private Observable            notifier  = null; // Observable Object
  private maskSymbolsListStruct stSymbols = null; // Porosity Type Symbols

  private int        iWidth  = 0;                // Width of the plot panel
  private int        iHeight = 0;                // Height of the plot panel

  private phiPlotSymbol plot = null;             // Porosity Plot Symbol Package

  private ScrollPane  scroll = new ScrollPane(); // Scroll Pane
  private JPanel      panel  = new JPanel();     // Panel containing plot

  /** Constructor phiPlotSymbolPanel()
   *  <p> This is the Constructor for this class.
   *  @param parent    = the frame calling this panel
   *  @param notifier  = Observable
   *  @param stSymbols = Porosity Types Plot Symbols List Data Structure
   */

  public phiPlotSymbolPanel( JFrame parent, Observable notifier,
                             maskSymbolsListStruct stSymbols)
  {
    try
    {
      this.parent    = parent;
      this.notifier  = notifier;
      this.stSymbols = stSymbols;

      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    Panel pnlCenter       = new Panel();
    JPanel pnlHeader      = new JPanel();
    JPanel pnlSouth       = new JPanel();
    JPanel pnlNorth       = new JPanel();
    JLabel lblHeader      = new JLabel();
    JLabel lblDescription = new JLabel();

    this.setLayout(new BorderLayout());
    pnlCenter.setLayout(new BorderLayout());

    plot    = new phiPlotSymbol( notifier, stSymbols );
    iWidth  = plot.getPlotWidth();
    iHeight = plot.getPlotHeight();

    panel.setLayout(new BorderLayout());
    panel.setPreferredSize(new Dimension(iWidth, iHeight));
    panel.setBackground(Color.white);

    // Header Panel

    pnlHeader.setLayout(new BorderLayout());

    // List Header Panel

    pnlSouth.setLayout(new BorderLayout());

    lblHeader.setFont(new java.awt.Font("Dialog", 1, 11));
    lblHeader.setText("    P  S   Image     Description");

    // Description of Columns Panel

    pnlNorth.setLayout(new BorderLayout());

    lblDescription.setFont(new java.awt.Font("Dialog", 2, 11));
    lblDescription.setForeground(Color.gray);
    lblDescription.setText("P=Primary Porosity; S=Secondary Porosity");

    // Attach Widgets to Panel

    this.add(pnlCenter,          BorderLayout.CENTER);
    pnlCenter.add(scroll,        BorderLayout.CENTER);
    scroll.add(panel,            null);
    panel.add(plot,              BorderLayout.CENTER);

    pnlCenter.add(pnlHeader,     BorderLayout.NORTH);
    pnlHeader.add(pnlSouth,      BorderLayout.CENTER);
    pnlSouth.add(lblHeader,      BorderLayout.WEST);

    pnlHeader.add(pnlNorth,      BorderLayout.NORTH);
    pnlNorth.add(lblDescription, BorderLayout.WEST);
  }

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
    parent    = null; // Frame callint this panel
    notifier  = null; // Observable Object
    stSymbols = null; // Symbols Plot Data Structure

    scroll  = null;
    panel   = null;

    if (plot != null)
      plot.close();
    plot    = null;
  }

  /* =============================================================== *
   * ------------------------- GET METHODS ------------------------- *
   * =============================================================== */

  /** Method getData()
   * <p> This method will get the array of porosity selected
   * @return st = phi data Structure
   */

  public phiStruct getData()
  {
    phiStruct st = null;

    if (plot != null) st = plot.getData();

    return (st);
  }

  /* =============================================================== *
   * ------------------------- SET METHODS ------------------------- *
   * =============================================================== */

  /** Method setData()
   * <p> This method will set the array of porosity selected
   * @param st = phi data Structure
   */

  public void setData(phiStruct st)
  {
    if (plot != null) plot.setData(st);
  }
}


/*
 *  @version 1.1 09/29/2008
 *  @author  John Victorine
 */
