/*
 * @rockMapCSVFrame.java Version 1.1 1/16/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.gui;

import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.Observable;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import rock.io.rockCSVFile;
import rock.rockDataListStruct;

/** Class rockMapCSVFrame
 *  <p> This Class will allow the user to load data files from their PC or the
 *      KGS Database
 *
 *  @version 1.1 1/16/2008
 *  @author  John R. Victorine
 */

public class rockMapCSVFrame extends JFrame implements ActionListener
{
  // Input Variables

  private Observable notifier    = null;
  private String     sReadMethod = null;
  private String     sDirectory  = null;
  private String     sFilename   = null;

  // Global Frame Variables

  private int iRow = 3;
  private int iColumn[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                           0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                           0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                           0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                           0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

  private rockCSVFile pFILE = new rockCSVFile();
  private rockDataListStruct stList = null;

  private String sLine1 = "";
  private String sLine2 = "";

  // Global Frame Widgets

  private JButton btnLoad   = new JButton();
  private JButton btnCancel = new JButton();
  private JButton btnHelp   = new JButton();

  private JTextField txtStart = new JTextField();

  private JPanel     pnl[] = null;
  private JLabel     lbl[] = null;
  private JTextField txt[] = null;

  /** Constructor rockMapCSVFrame()
   *  <p> This is the Constructor for this class.
   *  @param notifier    = Observable
   *  @param sReadMethod = File Read Method
   *  @param sDirectory  = The Directory Path to the File
   *  @param sFilename   = The Filename
   */

  public rockMapCSVFrame(Observable notifier,
                         String     sReadMethod,
                         String     sDirectory,
                         String     sFilename)
  {
    try
    {
      this.notifier    = notifier;
      this.sReadMethod = sReadMethod;
      this.sDirectory  = sDirectory;
      this.sFilename   = sFilename;

      jbInit();

      if (sLine1 != null) { mapColumns( sLine1 ); }
      if (sLine2 != null) { mapColumns( sLine2 ); }
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Frame for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    JPanel pnlTop     = new JPanel();
    JPanel pnlButtons = new JPanel();
    JPanel pnlCenter  = new JPanel();
    JPanel pnlLine1   = new JPanel();
    JPanel pnlLine2   = new JPanel();
    JPanel pnlCHeader = new JPanel();
    JPanel pnlColumns = new JPanel();
    JPanel pnlStart   = new JPanel();
    JPanel pnl1       = new JPanel();
    JPanel pnlMap     = new JPanel();

    JLabel lblStart         = new JLabel();
    JLabel lblNote          = new JLabel();
    JLabel lblRockDataColumn = new JLabel();
    JLabel lblFileColumn    = new JLabel();

    JTextArea txtLine1 = new JTextArea();
    JTextArea txtLine2 = new JTextArea();

    JScrollPane scrollLine1   = new JScrollPane();
    JScrollPane scrollLine2   = new JScrollPane();
    JScrollPane scrollColumns = new JScrollPane();

    TitledBorder titledBorder1st = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "1st Line of Comma Delimited File:");

    TitledBorder titledBorder2nd = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "2nd Line of Comma Delimited File:");

    TitledBorder titledBorderRock = new TitledBorder(
        new EtchedBorder(EtchedBorder.RAISED,
                         Color.white,
                         new Color(165, 163, 151)),
        "Rock Data Columns:");

    titledBorder1st.setTitleFont(new java.awt.Font("Dialog", 1, 11));
    titledBorder2nd.setTitleFont(new java.awt.Font("Dialog", 1, 11));
    titledBorderRock.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    this.setTitle("Map File Column Number to Rock Data Column");
    this.getContentPane().setLayout(new BorderLayout());

    pnlButtons.setBorder(BorderFactory.createEtchedBorder());

    btnLoad.setFont(new java.awt.Font("Dialog", 1, 11));
    btnLoad.setPreferredSize(new Dimension(90, 25));
    btnLoad.setText("Load Data");
    btnLoad.addActionListener(this);

    btnCancel.setFont(new java.awt.Font("Dialog", 1, 11));
    btnCancel.setPreferredSize(new Dimension(90, 25));
    btnCancel.setText("Cancel");
    btnCancel.addActionListener(this);

    btnHelp.setFont(new java.awt.Font("Dialog", 1, 11));
    btnHelp.setPreferredSize(new Dimension(90, 25));
    btnHelp.setText("Help");
    btnHelp.addActionListener(this);

    pnlTop.setLayout(new GridLayout(2,1));

    pnlLine1.setBorder(titledBorder1st);
    pnlLine1.setLayout(new BorderLayout());

    txtLine1.setEditable(false);
    txtLine1.setLineWrap(true);
    txtLine1.setText("");
    txtLine1.setRows(3);
    txtLine1.setWrapStyleWord(true);

    pnlLine2.setBorder(titledBorder2nd);
    pnlLine2.setLayout(new BorderLayout());

    txtLine2.setEditable(false);
    txtLine2.setLineWrap(true);
    txtLine2.setText("");
    txtLine2.setRows(3);
    txtLine2.setWrapStyleWord(true);

    pnlCenter.setLayout(new BorderLayout());
    pnlCenter.setBorder(titledBorderRock);

    pnlCHeader.setLayout(new BorderLayout());

    lblStart.setFont(new java.awt.Font("Dialog", 1, 11));
    lblStart.setText("Start Reading Data at Row");

    txtStart.setText("3");
    txtStart.setColumns(4);
    txtStart.setHorizontalAlignment(SwingConstants.TRAILING);
    txtStart.addFocusListener(new rockMapCSVFrameFocusAdapter(this));

    lblNote.setFont(new java.awt.Font("Dialog", 1, 11));
    lblNote.setText("Assume Row & Column Count is 1,2,3 ...");

    pnlColumns.setLayout(new BorderLayout());

    // Build Map Panel

    pnlMap.setLayout(new GridLayout(rock.rockStandardTools.TOTAL+1,1));

    // .. Add Header to Map Panel

    pnl1.setLayout(new BorderLayout());

    lblRockDataColumn.setFont(new java.awt.Font("Dialog", 1, 11));
    lblRockDataColumn.setText("Rock Data Column Name");

    lblFileColumn.setFont(new java.awt.Font("Dialog", 1, 11));
    lblFileColumn.setText("File Column Number");

    pnlMap.add(pnl1, null);
    pnl1.add(lblRockDataColumn, BorderLayout.WEST);
    pnl1.add(lblFileColumn, BorderLayout.EAST);

    // .. Add the Regions Columns to Map Panel

    pnl = new JPanel[rock.rockStandardTools.TOTAL];
    lbl = new JLabel[rock.rockStandardTools.TOTAL];
    txt = new JTextField[rock.rockStandardTools.TOTAL];

    for (int i=0; i<rock.rockStandardTools.TOTAL; i++)
    {
      pnl[i] = new JPanel();
      pnl[i].setLayout(new BorderLayout());
      pnl[i].setBorder(BorderFactory.createEtchedBorder());

      lbl[i] = new JLabel();
      lbl[i].setFont(new java.awt.Font("Dialog", 1, 11));
      lbl[i].setText("  " + rock.rockStandardTools.ROCK_TOOLS[i][1]);

      txt[i] = new JTextField();
      txt[i].setText("0");
      txt[i].setColumns(4);
      txt[i].setHorizontalAlignment(SwingConstants.TRAILING);
      txt[i].addFocusListener(new rockMapCSVFrameFocusAdapter(this));

      pnlMap.add(pnl[i], null);
      pnl[i].add(lbl[i], BorderLayout.CENTER);
      pnl[i].add(txt[i], BorderLayout.EAST);
    }

    // Add 1st & 2nd Line to Frame

    pFILE.Open(util.utilFileIO.DIRECTORY, sDirectory, sFilename);
    pFILE.get2Rows();
    pFILE.Close();

    sLine1 = new String( pFILE.getLine1() );
    sLine2 = new String( pFILE.getLine2() );

    txtLine1.setText( sLine1 );
    txtLine2.setText( sLine2 );

    // Attach Widgets to Frame

    this.getContentPane().add(pnlTop, BorderLayout.NORTH);
    pnlTop.add(pnlLine1, null);
    pnlLine1.add(scrollLine1,  BorderLayout.CENTER);
    scrollLine1.getViewport().add(txtLine1, null);

    pnlTop.add(pnlLine2, null);
    pnlLine2.add(scrollLine2, BorderLayout.CENTER);
    scrollLine2.getViewport().add(txtLine2, null);

    this.getContentPane().add(pnlButtons, BorderLayout.SOUTH);
    pnlButtons.add(btnLoad,   null);
    pnlButtons.add(btnCancel, null);
    pnlButtons.add(btnHelp,   null);

    this.getContentPane().add(pnlCenter, BorderLayout.CENTER);
    pnlCenter.add(pnlCHeader, BorderLayout.NORTH);
    pnlCHeader.add(pnlStart,  BorderLayout.WEST);
    pnlStart.add(lblStart,    null);
    pnlStart.add(txtStart,    null);
    pnlCHeader.add(lblNote,   BorderLayout.EAST);

    pnlCenter.add(pnlColumns,     BorderLayout.CENTER);
    pnlColumns.add(scrollColumns, BorderLayout.CENTER);
    scrollColumns.getViewport().add(pnlMap, null);

    // Display the Frame

//    this.setSize(new Dimension(500, 450));
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    this.setSize(new Dimension(550, d.height-50));

    this.setLocation((d.width  - this.getSize().width) / 2, 5 );
//                     (d.height - this.getSize().height) / 2);

    this.setResizable(true);
    this.setVisible(true);
  }

  /* ====================================================================== *
   * ----------------------------- GET METHODS ---------------------------- *
   * ====================================================================== */

  /** Method getRock()
   * <p> This method will return tops list
   * @return stList = rock data list structure
   */

  public rockDataListStruct getRock() { return (stList); }

  /* ====================================================================== *
   * ----------------------------- SET METHODS ---------------------------- *
   * ====================================================================== */

  /** Method mapColumns()
   *  <p> This method will try to parse and map the columns of the text
   *      file to the brine columns.
   *  @param sData = Line
   */

  private void mapColumns( String sData )
  {
	int i, j, k;
    int    iCount   = 0;
    int    iFound   = 0;
    int    iNext    = 0;
    int    iColumns = 0;
    String sTemp    = "";
    String sCol     = "";
    StringTokenizer stToken = null;
    String sTokens[] = null;

    sTemp    = new String(sData.replace('\t', ' '));
    sTokens  = las3.las3Parse.splitDataLine( sTemp, "," );

    iColumns = 0;
    if (sTokens != null)
      iColumns = sTokens.length;

    for (i=0; i<iColumns; i++)
    {
      sTemp = sTokens[i];
      sTemp = new String(sTemp.toUpperCase());
      sTemp = new String(sTemp.trim());

      for  (j=0; j<rock.rockStandardTools.TOTAL; j++)
      {
		for (k=0; k<2; k++)
		{
          sCol = new String( rock.rockStandardTools.ROCK_TOOLS[j][k] );
          sCol = new String( sCol.toUpperCase() );

		  if (sTemp.equals(sCol))
		  {
            iNext      = i+1;
			txt[j].setText(""+iNext);
		  }

		  if (j==rock.rockStandardTools._TOP)
		  {
		    if (txt[j].getText().equals("0"))
		    {
			  if ((sTemp.equals("START")) ||
			      (sTemp.equals("BEGIN")) ||
			      (sTemp.equals("TOP")) ||
			      (sTemp.equals("DEPTH")) ||
			      (sTemp.equals("STARTING DEPTH")) ||
			      (sTemp.equals("BEGIN DEPTH")))
			  {
                iNext      = i+1;
  			    txt[j].setText(""+iNext);
			  }
			}
		  }

		  if (j==rock.rockStandardTools._BASE)
		  {
		    if (txt[j].getText().equals("0"))
		    {
			  if ((sTemp.equals("END")) ||
			      (sTemp.equals("BASE")) ||
			      (sTemp.equals("ENDING DEPTH")) ||
			      (sTemp.equals("END DEPTH")))
			  {
                iNext      = i+1;
  			    txt[j].setText(""+iNext);
			  }
			}
		  }
		}
      }
    }

    for (i=0; i<rock.rockStandardTools.TOTAL; i++)
    {
      iColumn[i] = cmn.cmnString.stringToInt(txt[i].getText());
    }
  }

  /* ====================================================================== *
   * ---------------------------- ACTIONS --------------------------------- *
   * ====================================================================== */

  /** Method load()
   * <p> This method will load the read and parse the regions file
   */

  private void load()
  {
    pFILE.Open(util.utilFileIO.DIRECTORY, sDirectory, sFilename);
    pFILE.getData(iRow, iColumn);
    pFILE.Close();

    stList = pFILE.getRock();

    notifier.notifyObservers(new String("Rock CSV File Loaded"));
  }

  /** Method close()
   * <p> This method will set global variables to null in order to force JAVA
   *     to free unwanted memory.
   */

  public void close()
  {
    notifier    = null;
    sReadMethod = null;
    sDirectory  = null;
    sFilename   = null;

    iColumn     = null;

    sLine1      = null;
    sLine2      = null;

    if (pFILE != null)
      pFILE.delete();
    pFILE = null;

//    if (stList != null)
//      stList.delete();
    stList = null;

    btnLoad     = null;
    btnCancel   = null;
    btnHelp     = null;
    txtStart    = null;

    for (int i=0; i<rock.rockStandardTools.TOTAL; i++)
    {
      pnl[i] = null;
      lbl[i] = null;
      txt[i] = null;
    }

    dispose();
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    if (event.getSource() == btnLoad) { load(); }
    if (event.getSource() == btnHelp)
    {
      util.BrowserControl.displayURL( cmn.cmnStruct.PC_CORE );
    }
    if (event.getSource() == btnCancel) { close(); }
  }

  /** METHOD focusLost()
   *  <p> This Method will handle the lost focus event for the text fields.
   *  @param e      = Focus Lost Event
   */

  protected void focusLost(FocusEvent e)
  {
    int    i        = 0;
    int    iNumeric = 0;
    String sMessage = new String("");
    String sTemp    = new String("");

    if (e.getSource() == txtStart)
    {
      iNumeric = 1;
      sTemp    = txtStart.getText();
      sMessage = new String("Starting Row Number is a Numeric Field");
    }

    for (i=0; i<rock.rockStandardTools.TOTAL; i++)
    {
      if (e.getSource() == txt[i])
      {
        iNumeric = 1;
        sTemp    = txt[i].getText();
        sMessage = new String("Column Number is a Numeric Field");
      }
    }

    if (iNumeric == 1)
    {
      if (!cmn.cmnString.isNumeric(sTemp))
      {
        JOptionPane.showMessageDialog((Component) null,
                                       sMessage,
                                       "ERROR",
                                       JOptionPane.ERROR_MESSAGE);
      }
      else
      {
        if (e.getSource() == txtStart)
        {
          iRow = cmn.cmnString.stringToInt(txtStart.getText());
        }

        for (i=0; i<rock.rockStandardTools.TOTAL; i++)
        {
          if (e.getSource() == txt[i])
          {
            iColumn[i] = cmn.cmnString.stringToInt(txt[i].getText());
          }
        }
      }
    }
  }
}

/** CLASS rockMapCSVFrameFocusAdapter()
  *  <p> This Method will handle Actions when focus is lost on a textfield
  */

class rockMapCSVFrameFocusAdapter extends java.awt.event.FocusAdapter
{
  rockMapCSVFrame adaptee;

  rockMapCSVFrameFocusAdapter(rockMapCSVFrame adaptee)
  {
    this.adaptee = adaptee;
  }

  public void focusLost(FocusEvent e) { adaptee.focusLost(e); }
}

/*
 *  @version 1.1 1/16/2008
 *  @author  John Victorine
 */
