/*
 * @rockImageViewFrame.java Version 1.1 11/09/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.gui;

import java.net.*;
import java.lang.*;
import javax.swing.*;
import java.awt.*;

import cmn.cmnStruct;
import rock.rockImagesListStruct;

/** Class rockImageViewFrame
 *  <p> This class will allow the user to select core Images.
 *
 *  @version 1.1 11/09/2007
 *  @author  John R. Victorine
 */

public class rockImageViewFrame extends JFrame
{
  private cmnStruct stCMN = null;

  private int iWidth = 300;
  private rockImagesListStruct stImages = null;
  private rockImageViewFramePlotCanvas pCoreImage = null;

  private JPanel pnl = new JPanel();

  /** Constructor rockImageViewFrame()
   *  <p> This is the Constructor for this class.
   */

  public rockImageViewFrame()
  {
    try
    {
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** Method jbInit()
   *  <p> This method will create this Frame.
   * @throws Exception
   */

  private void jbInit() throws Exception
  {
    JScrollPane scroll = new JScrollPane();

    this.setTitle("IMAGE");
    this.getContentPane().setLayout(new BorderLayout());

    this.getContentPane().add(scroll, BorderLayout.CENTER);
    scroll.getViewport().add(pnl, null);

    // Set Size and Location of Frame

    this.setSize(350, 375);

//    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
//    this.setLocation((d.width  - this.getSize().width)/2,
//                     (d.height - this.getSize().height)/2);
    this.setLocation(10, 10);
    this.setResizable(false);
    this.setVisible(false);
  }

  /** Method hide()
   * <p> This method will hide this Frame
   */

  public void cancel() { this.setVisible(false); }

  /** Method close()
   * <p> This method will set the variables to null in order to force Java to
   *     free its memory
   */

  public void close()
  {
    stCMN = null;

    stImages   = null;
    pCoreImage = null;

    pnl = null;
  }

  /* =============================================================== *
   * ------------------------- SET METHODS ------------------------- *
   * =============================================================== */

  /** Method setCommon()
   * <p> This method will set the Global Common Data Structure
   *  @param stCMN  = the Global Common Data Structure
   */

  public void setCommon(cmnStruct stCMN) { this.stCMN = stCMN; }

  /** Method setRockImages()
   * <p> This method will set the Rock Image Data
   * @param st = The Rock Image Data List Structure
   */

  public void setRockImages(rockImagesListStruct st) { this.stImages = st; }

  /** Method DisplayCoreImage()
   *  <p> This Panel will display the Core Image
   *  @param sKEY   = The Primary Key for the Core Image
   */

  public void DisplayCoreImage(String sKEY)
  {
    JScrollPane psImage      = new JScrollPane();
    String      sFilename    = "";
    URL         urlCore      = null; //getURL(sFilename);
    int         iImageWidth  = iWidth;
    int         iImageHeight = iWidth;
    int         iRow         = -1;

    for (int i=0; i<stImages.iCount; i++)
    {
      if (sKEY.equals(stImages.stItem[i].sKID))
      {
        iRow = i;
      }
    }

    if (iRow > -1)
    {
      sFilename = new String(stImages.stItem[iRow].sURL + "/" +
                             stImages.stItem[iRow].sFilename);
      urlCore = getURL(sFilename);

      if (stImages.stItem[iRow].sType.equals(cmn.cmnStruct.CORE_IMAGES[0]))
      {
        iImageWidth =  iWidth / 2;
      }

      Image image = Toolkit.getDefaultToolkit().getImage(urlCore);

      if (pCoreImage == null)
      {
        pCoreImage = new rockImageViewFramePlotCanvas(image,
                                                      iImageWidth,
                                                      iImageHeight);
        pCoreImage.setBackground(Color.white);
        psImage.getViewport().add(pCoreImage, null);

        if (pnl != null)
          pnl.add(psImage, null);
      }
      else
        pCoreImage.setImage(image, iImageWidth, iImageHeight);
    }

    this.setVisible(true);
  }

  /** METHOD getURL()
   *  <p> This method will locate the URL for the specific file.
   * @param  filename = The Filename to be converted to URL
   * @return url      = The URL of the Filename.
   */

  protected URL getURL(String filename)
  {
     URL url         = null;
     URL urlCodeBase = null;

     if (urlCodeBase == null)
     {
       urlCodeBase = stCMN.urlDirCodeBase;
     }

     try
     {
       url = new URL(urlCodeBase, filename);
     }
     catch (java.net.MalformedURLException e)
     {
       String Message = new String("rockImageViewFrame.getURL(): \n" +
                                  e.getMessage() + "\n" +
                                  "Couldn't create image: " + filename);
       System.out.println(e.getMessage());
       JOptionPane.showMessageDialog((Component) null,
                                     Message,
                                     "ERROR",
                                     JOptionPane.ERROR_MESSAGE);
       return null;
     }

     return url;
  }
}

/** Class rockImageViewFramePlotCanvas
 *  <p> This class will create a Canvas to draw the Core Image.
 */

class rockImageViewFramePlotCanvas extends Canvas
{
  Image saved_i;
  int   iX;
  int   iY;

  public rockImageViewFramePlotCanvas(Image i, int ix, int iy)
  {
    saved_i = i;
    iX = ix;
    iY = iy;
    this.setSize(iX, iY);
  }

  public void setImage(Image i, int ix, int iy)
  {
    saved_i = i;
    iX = ix;
    iY = iy;
    this.setSize(iX, iY);

    repaint();
  }

  public void paint(Graphics g)
  {
    g.drawImage(saved_i, 0, 0, iX, iY, this);
  }
}
