/*
 * @rockImageFrame.java Version 1.1 11/08/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.Observable;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import cmn.cmnStruct;
import rock.gui.rockImagePanel;
import rock.rockImagesListStruct;

/** Class rockImageFrame
 *  <p> This class will allow the user to select core Images.
 *
 *  @version 1.1 11/08/2007
 *  @author  John R. Victorine
 */

public class rockImageFrame extends JFrame implements ActionListener
{
  // Input Variables

  private Observable           notifier = null;
  private cmnStruct            stCMN    = null;
  private rockImagesListStruct stImages = null;

  // Global Variables

  private int iDisplay[] = { cmn.cmnStruct.ON,
                             cmn.cmnStruct.ON,
                             cmn.cmnStruct.ON };
//  private int iState     = cmn.cmnStruct.SELECT;

  private rockImagePanel pImageTable = null;

  // Global Widgets

  private static final String BTN_OK    = "Ok";
  private static final String BTN_CLOSE = "Close";

  private JButton btnOk    = new JButton();
  private JButton btnClose = new JButton();

  private JButton btnBox  = new JButton();
  private JButton btnSlab = new JButton();
  private JButton btnThin = new JButton();

  /** Constructor rockImageFrame()
   *  <p> This is the Constructor for this class.
   *  @param stCMN    = The Common Global Data Structure
   *  @param notifier = Observable
   *  @param stImages = Rock Image Data List Structure
   */

  public rockImageFrame(cmnStruct stCMN,
                        Observable notifier,
                        rockImagesListStruct stImages)
  {
    try
    {
      this.stCMN    = stCMN;
      this.notifier = notifier;
      this.stImages = stImages;
      if (this.stImages != null)
      {
        jbInit();
      }
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** Method jbInit()
   *  <p> This method will create this Frame.
   * @throws Exception
   */

  private void jbInit() throws Exception
  {
    JPanel pButtons       = new JPanel();
    JPanel pWest          = new JPanel();
    JPanel pCenter        = new JPanel();
    JPanel pCoreTypes     = new JPanel();
    JPanel pImageView     = new JPanel();
    JPanel pFilterLabel   = new JPanel();
    JPanel pFilterButtons = new JPanel();
    JPanel pBoxes         = new JPanel();
    JPanel pThin          = new JPanel();
    JPanel pSlabs         = new JPanel();
    JPanel pBTNBox        = new JPanel();
    JPanel pBTNSlab       = new JPanel();
    JPanel pBTNThin       = new JPanel();
    JPanel jPanel1        = new JPanel();
    JPanel pImage         = new JPanel();

    JLabel lblTypeBy      = new JLabel();
    JLabel lblBoxes       = new JLabel();
    JLabel lblSlab        = new JLabel();
    JLabel lblThin        = new JLabel();

    ScrollPane psImages    = new ScrollPane();
    ScrollPane scrollPane1 = new ScrollPane();

    TitledBorder titledBorderOrig = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Depth Range:");
    titledBorderOrig.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    this.setTitle("Core Images List");
    this.getContentPane().setLayout(new BorderLayout());

    pButtons.setBorder(BorderFactory.createEtchedBorder());

    pWest.setEnabled(true);
    pWest.setBorder(BorderFactory.createEtchedBorder());
    pWest.setPreferredSize(new Dimension(150, 14));
    pWest.setLayout(new BorderLayout());

    pCenter.setLayout(new BorderLayout());

    pCoreTypes.setPreferredSize(new Dimension(10, 120));
    pCoreTypes.setLayout(new BorderLayout());
    pFilterLabel.setBorder(BorderFactory.createEtchedBorder());
    pFilterButtons.setLayout(new GridLayout(3,1));

    pBoxes.setLayout(new BorderLayout());
    pBoxes.setBorder(BorderFactory.createEtchedBorder());
    pSlabs.setLayout(new BorderLayout());
    pSlabs.setBorder(BorderFactory.createEtchedBorder());
    pThin.setLayout(new BorderLayout());
    pThin.setBorder(BorderFactory.createEtchedBorder());

    pBTNThin.setLayout(new BorderLayout());
    pBTNThin.setPreferredSize(new Dimension(30, 30));
    pBTNSlab.setLayout(new BorderLayout());
    pBTNSlab.setPreferredSize(new Dimension(30, 30));
    pBTNBox.setLayout(new BorderLayout());
    pBTNBox.setPreferredSize(new Dimension(30, 30));

    pImageView.setLayout(new BorderLayout());
    pImage.setBackground(Color.white);

    lblTypeBy.setFont(new java.awt.Font("Dialog", 1, 11));
    lblTypeBy.setText("Filter by Image Type:");

    btnOk.setFont(new java.awt.Font("Dialog", 1, 11));
    btnOk.setText(BTN_OK);
    btnOk.addActionListener(this);

    btnClose.setFont(new java.awt.Font("Dialog", 1, 11));
    btnClose.setText(BTN_CLOSE);
    btnClose.addActionListener(this);

    btnBox.setBackground(Color.yellow);
    btnBox.setFont(new java.awt.Font("Dialog", 1, 11));
    btnBox.setForeground(Color.darkGray);
    btnBox.setBorder(BorderFactory.createRaisedBevelBorder());
    btnBox.setText("Yes");
    btnBox.addActionListener(this);

    btnSlab.setBackground(Color.yellow);
    btnSlab.setFont(new java.awt.Font("Dialog", 1, 11));
    btnSlab.setForeground(Color.darkGray);
    btnSlab.setBorder(BorderFactory.createRaisedBevelBorder());
    btnSlab.setText("Yes");
    btnSlab.addActionListener(this);

    btnThin.setBackground(Color.yellow);
    btnThin.setFont(new java.awt.Font("Dialog", 1, 11));
    btnThin.setForeground(Color.darkGray);
    btnThin.setBorder(BorderFactory.createRaisedBevelBorder());
    btnThin.setText("Yes");
    btnThin.addActionListener(this);

    lblBoxes.setFont(new java.awt.Font("Dialog", 1, 11));
    lblBoxes.setText("  Core Boxes");
    lblSlab.setFont(new java.awt.Font("Dialog", 1, 11));
    lblSlab.setText("  Core Slabs");
    lblThin.setFont(new java.awt.Font("Dialog", 1, 11));
    lblThin.setText("  Core Thin Sections");

    // Build Image Table

    pImageTable = new rockImagePanel(stCMN, notifier, stImages);
    pImageTable.setImageDisplayPanel(pImage, 150);
    pImageTable.setFilterType(iDisplay);

    // Attach Widgets to Frame

    this.getContentPane().add(pButtons, BorderLayout.SOUTH);
    pButtons.add(btnOk,                 null);
    pButtons.add(btnClose,              null);

    this.getContentPane().add(pWest,   BorderLayout.WEST);
    pWest.add(pCoreTypes,              BorderLayout.NORTH);

    pCoreTypes.add(pFilterLabel,       BorderLayout.NORTH);
    pFilterLabel.add(lblTypeBy,        null);

    pCoreTypes.add(pFilterButtons,     BorderLayout.CENTER);
    pFilterButtons.add(pBoxes,         null);
    pBoxes.add(lblBoxes,               BorderLayout.CENTER);
    pBoxes.add(pBTNBox,                BorderLayout.WEST);
    pBTNBox.add(btnBox,                BorderLayout.CENTER);

    pFilterButtons.add(pSlabs,         null);
    pSlabs.add(lblSlab,                BorderLayout.CENTER);
    pSlabs.add(pBTNSlab,               BorderLayout.WEST);
    pBTNSlab.add(btnSlab,              BorderLayout.CENTER);

    pFilterButtons.add(pThin,          null);
    pThin.add(lblThin,                 BorderLayout.CENTER);
    pThin.add(pBTNThin,                BorderLayout.WEST);
    pBTNThin.add(btnThin,              BorderLayout.CENTER);

    pWest.add(pImageView,              BorderLayout.CENTER);
    pImageView.add(scrollPane1,        BorderLayout.CENTER);
    scrollPane1.add(pImage,            null);

    this.getContentPane().add(pCenter, BorderLayout.CENTER);
    pCenter.add(psImages, BorderLayout.CENTER);
    psImages.add(pImageTable,          null);

    // Set Size and Location of Frame

    this.setSize(650, 400);

    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    this.setLocation((d.width  - this.getSize().width)/2,
                     (d.height - this.getSize().height)/2);

    this.setResizable(false);
    this.setVisible(true);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getData()
   * <p> This method will retrieve the selected data for download.
   * @return The Selected Core Image List Data for Download.
   */

  public rockImagesListStruct getData() { return (pImageTable.getData()); }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setSelection()
   *  <p> This method will set the LAS File Selection Buttons by Type.
   *  @param iType - The Type of Button selected.
   *

  public void setSelection(int iType)
  {
    int i=0;

    this.iState = iType;
    switch (iType)
    {
      case cmn.cmnStruct.ALL:
        for (i=0; i < 3; i++)
          setColor(i, cmn.cmnStruct.ON);
        break;

      case cmn.cmnStruct.SELECT:
      case cmn.cmnStruct.NONE:
        for (i=0; i < 3; i++)
          setColor(i, cmn.cmnStruct.OFF);
        break;
    }

    pImageTable.setFilterType(iDisplay);
    pImageTable.setSelection(iType);
  }
*/
  /** Method setColor()
   * <p> This method will set the button color of the On/Off Button
   * @param  iButton = The Button Number
   * @param  iStatus = The Status of the Button
   */

  private void setColor(int iButton)
  {
    String sText   = "";
    int    iStatus = cmn.cmnStruct.OFF;

    switch (iButton)
    {
      case cmn.cmnStruct.CORE_BOX:
        sText = btnBox.getText();
        break;
      case cmn.cmnStruct.CORE_SLAB:
        sText = btnSlab.getText();
        break;
      case cmn.cmnStruct.CORE_THIN:
        sText = btnThin.getText();
        break;
    }

    if (sText.equals("No"))
      iStatus = cmn.cmnStruct.ON;
    else if (sText.equals("Yes"))
      iStatus = cmn.cmnStruct.OFF;

    switch (iButton)
    {
      case cmn.cmnStruct.CORE_BOX:
        switch (iStatus)
        {
          case cmn.cmnStruct.OFF:
            iDisplay[iButton] = cmn.cmnStruct.OFF;
            btnBox.setText("No");
            btnBox.setBackground(Color.darkGray);
            btnBox.setForeground(Color.yellow);
            break;

          case cmn.cmnStruct.ON:
            iDisplay[iButton] = cmn.cmnStruct.ON;
            btnBox.setText("Yes");
            btnBox.setBackground(Color.yellow);
            btnBox.setForeground(Color.darkGray);
            break;
        }
        break;

      case cmn.cmnStruct.CORE_SLAB:
        switch (iStatus)
        {
          case cmn.cmnStruct.OFF:
            iDisplay[iButton] = cmn.cmnStruct.OFF;
            btnSlab.setText("No");
            btnSlab.setBackground(Color.darkGray);
            btnSlab.setForeground(Color.yellow);
            break;

          case cmn.cmnStruct.ON:
            iDisplay[iButton] = cmn.cmnStruct.ON;
            btnSlab.setText("Yes");
            btnSlab.setBackground(Color.yellow);
            btnSlab.setForeground(Color.darkGray);
            break;
        }
        break;

      case cmn.cmnStruct.CORE_THIN:
        switch (iStatus)
        {
          case cmn.cmnStruct.OFF:
            iDisplay[iButton] = cmn.cmnStruct.OFF;
            btnThin.setText("No");
            btnThin.setBackground(Color.darkGray);
            btnThin.setForeground(Color.yellow);
            break;

          case cmn.cmnStruct.ON:
            iDisplay[iButton] = cmn.cmnStruct.ON;
            btnThin.setText("Yes");
            btnThin.setBackground(Color.yellow);
            btnThin.setForeground(Color.darkGray);
            break;
        }
        break;
    }
  }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** Method close()
   * <p> This method will close this dialog and set objects to null to force
   *     Java to free memory
   */

  public void close()
  {
    stCMN    = null;
    stImages = null;

    iDisplay = null;

    if (pImageTable != null)
      pImageTable.close();
    pImageTable = null;

    btnOk   = null;
    btnClose = null;
    btnBox  = null;
    btnSlab = null;
    btnThin = null;

    dispose();
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Well Curve
   *      Selection Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    String sEventArgument = event.getActionCommand();

//    if (iState == cmn.cmnStruct.SELECT)
//    {
    if (event.getSource() == btnBox)  { setColor(0); }
    if (event.getSource() == btnSlab) { setColor(1); }
    if (event.getSource() == btnThin) { setColor(2); }
//    }

    if (pImageTable != null)
      pImageTable.setFilterType(iDisplay);

    if (event.getSource() == btnOk)
    {
      notifier.notifyObservers(new String("Get Core Images"));
    }
    if (event.getSource() == btnClose) { close(); }
  }
}