/*
 * @fossilPlotLegendBuffered.java Version 1.1 03/09/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.fossil.plot;

import java.awt.*;
import java.awt.image.*;

import mask.maskSymbolsListStruct;
import rock.fossil.plot.fossilPlotLegend;

/** Class fossilPlotLegendBuffered
 *  <p> This Class will create a buffered image.
 *
 *  @version 1.1 03/09/2009
 *  @author  John R. Victorine
 */

public class fossilPlotLegendBuffered
{
  /** Method makePlotImage()
   *  This method will plot well profile data.  The plot is then converted to
   *  an buffered image and passed back to the calling routine.
   * @param iSelected = Array of indicators for plotting fossils
   * @param stFossils = Fossil Plot Symbols List Data Structure
   * @return image    = Fossil Symbols plot buffered image
   */

  public static BufferedImage makePlotImage( int iSelected[],
                                             maskSymbolsListStruct stFossils )
  {
    BufferedImage    image = null;
    fossilPlotLegend plot  = null;
    int iWidth  = 0;
    int iHeight = 0;

    plot    = new fossilPlotLegend( iSelected, stFossils );
    iWidth  = plot.getPlotWidth();
    iHeight = plot.getPlotHeight();

    // Build Buffered Image

    image = new BufferedImage(iWidth, iHeight, BufferedImage.TYPE_INT_RGB);

    Graphics graphics = image.getGraphics();

    graphics.setColor(Color.white);
    graphics.fillRect(0, 0, iWidth, iHeight);

    plot.draw(graphics);

    graphics.dispose();

    return (image);
  }
}

/*
 *  @version 1.1 03/09/2009
 *  @author  John Victorine
 */
