/*
 * @fossilListStruct.java Version 1.1 09/24/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.fossil;

import rock.fossil.fossilStruct;

/** Class fossilListStruct
 *  <p> This Class holds the Rock Fossil Depth Data.
 *
 *  @version 1.1 09/24/2007
 *  @author  John R. Victorine
 */

public class fossilListStruct
{
  // Stratigraphic Headers Data Information

  public String sKID       = "0";  // Primary Key of the Well
  public String sKEY       = "";   // Primary Key created on user's PC
  public int    iType      = iqstrat.iqstratHeadersStruct.WELL; // Type of Data
  public String sAPI       = "";   // API-Number OR UWI
  public String sName      = "";   // Well Name or Outcrop Name
  public String status     = iqstrat.iqstratStatusStruct.STATUS[0][0]; // Status
  public double dLatitude  = 0.0;  // Latitude of Location
  public double dLongitude = 0.0;  // Longitude of Location
  public double depth      = 0.0;  // Total Depth of Well or Height of Outcrop
  public double dGL        = 0.0;  // Ground Level

  public double depthStart = 0.0;  // Starting Depth
  public double depthEnd   = 0.0;  // Ending Depth

  // LAS 3 Dependent Variable

  public String sKGS     = "YES"; // KGS Saved Data Indicator
  public String source   = "";    // Source of Data
  public String sCreated = "";    // Created Date

  public int          iCount   = 0;    // Total Number of Records
  public fossilStruct stItem[] = null; // Total Rock Fossil Records


  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    sKID      = null; // Primary Key of the Well
    sKEY      = null; // Primary Key created on user's PC
    sAPI      = null; // API-Number OR UWI
    sName     = null; // Well Name or Outcrop Name
    status    = null; // Status

    sKGS      = null; // KGS Saved Data Indicator
    source    = null; // Source of Data
    sCreated  = null; // Created Date

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }
  }
}
