/*
 * @rockColorStruct.java Version 1.1 09/10/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.color;

/** Class rockColorStruct
 *  <p> This Class holds the Rock Color Depth Data.
 *
 *  @version 1.1 09/10/2007
 *  @author  John R. Victorine
 */

public class rockColorStruct
{
  public double depthStart = 0.0; // Starting Depth
  public double depthEnd   = 0.0; // Ending Depth

  public String sKEY       = "0"; // Unique Identifier for depth range

  public int    iTotal     = 0;  // Total Number of Colors for section
  public int    iRGB[][]   = { {-1,-1,-1}, {-1,-1,-1}, {-1,-1,-1} }; // RGB Color Values

  //                          Primary  Secondary Streaks
  public String sColor[]   = {   "",      "",      "" };
  public String sMunsell[] = {   "",      "",      "" };
  public String sRGBHex[]  = {   "",      "",      "" };

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    sKEY     = null;
    iRGB     = null;

    sColor   = null;
    sMunsell = null;
    sRGBHex  = null;
  }
}