/*
 * @rockColorChartStruct.java Version 1.1 11/06/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.color;

/** Class rockColorChartStruct
 *  <p> This Class holds the Rock/Soil Color Chart Data from the catalogs,
 *      ROCK-COLOR CHART by the THE ROCK-COLOR CHART COMMITTEE 1948 &
 *      Munsell Soil Color Charts 2000.
 *
 *  @version 1.1 11/06/2009
 *  @author  John R. Victorine
 */

public class rockColorChartStruct
{
  // Munsell Code Variables

  public String sMunsell = "";    // Code, i.e. Hue Value/Chroma
  public String sHue     = "";    // Hue
  public double dHue     = 0.0;   // Hue Number
  public String sColor   = "";    // Color, i.e. R (Red), Y (Yellow), ...
  public double dValue   = 0.0;   // Value (Lightness) 0 ... 10
  public double dChroma  = 0.0;   // Chroma color purity or colorfulness

  // Measured & Interpolated xyY Color Values

  public double x  = 0.0;
  public double y  = 0.0;
  public double Yo = 0.0;

  // Color Name & computed rgb value

  public String sName    = "";                 // Color Name
  public String sHex     = "#FFFFFF";
  public int    iRGB[]   = { 255, 255, 255 };  // RGB equivalent value

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    sMunsell = null;    // Munsell Code, i.e. Hue Value/Chroma
    sHue     = null;    // Munsell Hue
    sColor   = null;    // Munsell Color, i.e. R (Red), Y (Yellow), ...

    sName    = null;    // Color Name
    sHex     = null;    // Hex equivalent of RGB Value
    iRGB     = null;    // RGB equivalent value
  }
}