/*
 * @rockColorChartListStruct.java Version 1.1 11/06/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.color;

import rock.color.rockColorChartStruct;

/** Class rockColorChartListStruct
 *  <p> This Class holds the Rock/Soil Color Chart Data from the catalogs,
 *      ROCK-COLOR CHART by the THE ROCK-COLOR CHART COMMITTEE 1948 &
 *      Munsell Soil Color Charts 2000.
 *
 *  @version 1.1 11/06/2009
 *  @author  John R. Victorine
 */

public class rockColorChartListStruct
{
  public int                  iCount   = 0;    // Total Number of Records
  public rockColorChartStruct stItem[] = null; // Munell Colors

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}
