/*
 * @rockColorDataEntryPanel.java Version 1.1 09/10/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.color.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.Observer;
import java.util.Observable;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import iqstrat.iqstratStruct;
import rock.color.rockColorStruct;
import rock.color.gui.rockColorChartPlotFrame;

/** Class rockColorDataEntryPanel
 *  <p> This Class will display the rock colour chart by hue.
 *
 *  @version 1.1 09/10/2008
 *  @author  John R. Victorine
 */

public class rockColorDataEntryPanel extends JPanel implements ActionListener, Observer
{
  // Input Variables

  private Observable    notifier = null;  // Observable Object
  private iqstratStruct stStruct = null;  // Global IQSTRAT Data Structure

  // Global Variables

  private Observable              obsrvble   = null; // Observable

  private rockColorStruct         stColor    = null;
  private rockColorChartPlotFrame plotColors = null;

  // Depth range variables

  private double dStart = 0.0; // Starting Depth
  private double dEnd   = 0.0; // Ending Depth

  // Color Radio Buttons

  private static final int _PRIMARY   = 0;
  private static final int _SECONDARY = 1;
  private static final int _STREAKS   = 2;

  private int iButton = _PRIMARY;

  // Rock Color Variables

  public int iRGB[][] = { {-1,-1,-1}, {-1,-1,-1}, {-1,-1,-1} }; // RGB Color Values

  //                          Primary  Secondary Streaks
  public String sColor[]   = {   "",      "",      "" };
  public String sMunsell[] = {   "",      "",      "" };
  public String sRGBHex[]  = {   "",      "",      "" };

  // Global Panel Widgets

  // Depth Range Textfields

  private JTextField   txtStart       = new JTextField();
  private JTextField   txtEnd         = new JTextField();

  // Neutral Color Buttons

//  private JButton btnN9 = new JButton();
//  private JButton btnN8 = new JButton();
//  private JButton btnN7 = new JButton();
//  private JButton btnN6 = new JButton();
//  private JButton btnN5 = new JButton();
//  private JButton btnN4 = new JButton();
//  private JButton btnN3 = new JButton();
//  private JButton btnN2 = new JButton();
//  private JButton btnN1 = new JButton();

  // Add Color Selection to list

  private JButton btnAdd    = new JButton();
  private JButton btnClear  = new JButton();
  private JButton btnCancel = new JButton();

  // Primary Rock Color Widgets

  private JRadioButton rbPrimary          = new JRadioButton();
  private JButton      btnPrimary         = new JButton();      // View Color
  private JTextField   txtPrimaryMunsell  = new JTextField();   // Munsell Code
  private JTextField   txtPrimary         = new JTextField();   // ISCC Name

  // Secondary Rock Color Widgets

  private JRadioButton rbSecondary         = new JRadioButton();
  private JButton      btnSecondary        = new JButton();      // View Color
  private JTextField   txtSecondaryMunsell = new JTextField();   // Munsell Code
  private JTextField   txtSecondary        = new JTextField();   // ISCC Name

  // Streaks Color Widgets

  private JRadioButton rbStreaks           = new JRadioButton();
  private JButton      btnStreaks          = new JButton();      // View Color
  private JTextField   txtStreaksMunsell   = new JTextField();   // Munsell Code
  private JTextField   txtStreaks          = new JTextField();// ISCC Name

  // Dialog Position & Size

  private int iXStart = 0;
  private int iYStart = 0;
  private int iWidth  = 0;
  private int iHeight = 0;

  /** Constructor rockColorDataEntryPanel()
   *  <p> This is the Constructor for this class.
   *  @param notifier = Observable Object
   *  @param stStruct = Global IQSTRAT Data Structure
   */

  public rockColorDataEntryPanel( Observable notifier, iqstratStruct stStruct )
  {
    try
    {
      this.notifier = notifier;
      this.stStruct = stStruct;

      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
//    JPanel pnlNeutrals         = new JPanel();
    JPanel pnlCenter           = new JPanel();
    JPanel pnlButtons          = new JPanel();
    JPanel pnlText             = new JPanel();
    JPanel pnlPrimary          = new JPanel();
    JPanel pnlStreaks          = new JPanel();
    JPanel pnlSecondary        = new JPanel();
    JPanel pnlPrimaryBtn       = new JPanel();
    JPanel pnlPrimaryMunsell   = new JPanel();
    JPanel pnlPrimaryColor     = new JPanel();
    JPanel pnlSecondaryBtn     = new JPanel();
    JPanel pnlSecondaryMunsell = new JPanel();
    JPanel pnlSecondaryColor   = new JPanel();
    JPanel pnlStreaksBtn       = new JPanel();
    JPanel pnlStreaksMunsell   = new JPanel();
    JPanel pnlStreaksColor     = new JPanel();

    JPanel pnlDepthRange       = new JPanel();
    JPanel pnlStart            = new JPanel();
    JPanel pnlEnd              = new JPanel();

    JPanel pnlAdd              = new JPanel();
    JPanel pnlClear            = new JPanel();

    ButtonGroup groupColor = new ButtonGroup();

//    TitledBorder titledBorderNeutral = new TitledBorder(
//        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
//        "Munsell Neutral Colors:");

    TitledBorder titledBorderPrimary = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Primary Rock Color:");

    TitledBorder titledBorderSecondary = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Secondary Rock Color:");

    TitledBorder titledBorderStreaks = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Streaks:");

    TitledBorder titledBorderStart = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Starting Depth:");

    TitledBorder titledBorderEnd = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Ending Depth:");

//    titledBorderNeutral.setTitleFont(new java.awt.Font("Dialog", 1, 11));
    titledBorderPrimary.setTitleFont(new java.awt.Font("Dialog", 1, 11));
    titledBorderSecondary.setTitleFont(new java.awt.Font("Dialog", 1, 11));
    titledBorderStreaks.setTitleFont(new java.awt.Font("Dialog", 1, 11));
    titledBorderStart.setTitleFont(new java.awt.Font("Dialog", 1, 11));
    titledBorderEnd.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    // Create an Observable

    obsrvble = new rockColorDataEntryPanelObservable();

    // Add this Dialog to the notifier as observer

    obsrvble.addObserver(this);

    // Build Panel

    this.setLayout(new BorderLayout());

    // Center Panel

    pnlCenter.setLayout(new BorderLayout());

    // Neutral Color Button Panel
/*
    pnlNeutrals.setBorder(titledBorderNeutral);

    btnN9.setBackground(new Color(228, 228, 228));
    btnN9.setPreferredSize(new Dimension(50, 30));
    btnN9.setText("N9");
    btnN9.addActionListener(this);

    btnN8.setBackground(new Color(202, 202, 202));
    btnN8.setPreferredSize(new Dimension(50, 30));
    btnN8.setText("N8");
    btnN8.addActionListener(this);

    btnN7.setBackground(new Color(175, 175, 175));
    btnN7.setPreferredSize(new Dimension(50, 30));
    btnN7.setText("N7");
    btnN7.addActionListener(this);

    btnN6.setBackground(new Color(158, 158, 158));
    btnN6.setPreferredSize(new Dimension(50, 30));
    btnN6.setText("N6");
    btnN6.addActionListener(this);

    btnN5.setBackground(new Color(123, 123, 123));
    btnN5.setForeground(Color.white);
    btnN5.setPreferredSize(new Dimension(50, 30));
    btnN5.setText("N5");
    btnN5.addActionListener(this);

    btnN4.setBackground(new Color(97, 97, 97));
    btnN4.setForeground(Color.white);
    btnN4.setPreferredSize(new Dimension(50, 30));
    btnN4.setText("N4");
    btnN4.addActionListener(this);

    btnN3.setBackground(new Color(72, 72, 72));
    btnN3.setForeground(Color.white);
    btnN3.setPreferredSize(new Dimension(50, 30));
    btnN3.setText("N3");
    btnN3.addActionListener(this);

    btnN2.setBackground(new Color(49, 49, 49));
    btnN2.setForeground(Color.white);
    btnN2.setPreferredSize(new Dimension(50, 30));
    btnN2.setText("N2");
    btnN2.addActionListener(this);

    btnN1.setBackground(new Color(29, 29, 29));
    btnN1.setForeground(Color.white);
    btnN1.setPreferredSize(new Dimension(50, 30));
    btnN1.setText("N1");
    btnN1.addActionListener(this);
*/
    // Global Button Panel

    pnlButtons.setLayout(new GridLayout());
    pnlButtons.setBorder(BorderFactory.createEtchedBorder());

    // -- Add Button Panel

    pnlAdd.setLayout(new GridLayout(2,1));

    btnAdd.setFont(new java.awt.Font("Dialog", 1, 11));
    btnAdd.setText("Add");
    btnAdd.addActionListener(this);

    pnlClear.setLayout(new GridLayout());

    btnClear.setFont(new java.awt.Font("Dialog", 1, 11));
    btnClear.setText("Clear");
    btnClear.addActionListener(this);

    btnCancel.setFont(new java.awt.Font("Dialog", 1, 11));
//    btnCancel.setEnabled(false);
    btnCancel.setText("Cancel");
    btnCancel.addActionListener(this);

    // -- Depth Range Panel

    pnlDepthRange.setPreferredSize(new Dimension(100, 10));
    pnlDepthRange.setLayout(new GridLayout());

    // .. Starting Depth Panel

    pnlStart.setBorder(titledBorderStart);
    pnlStart.setLayout(new BorderLayout());

    txtStart.setText("0.0");
    txtStart.setEditable(false);
    txtStart.setHorizontalAlignment(SwingConstants.TRAILING);
    txtStart.addFocusListener(new rockColorDataEntryPanelFocusAdapter(this));

    // .. Endind Depth Panel

    pnlEnd.setBorder(titledBorderEnd);
    pnlEnd.setLayout(new BorderLayout());

    txtEnd.setText("0.0");
    txtEnd.setEditable(false);
    txtEnd.setHorizontalAlignment(SwingConstants.TRAILING);
    txtEnd.addFocusListener(new rockColorDataEntryPanelFocusAdapter(this));

    // Munsell Color text Panel

    pnlText.setLayout(new GridLayout());

    // Primary Rock Color Panel

    pnlPrimary.setBorder(titledBorderPrimary);
    pnlPrimary.setLayout(new GridLayout(2,1));

    pnlPrimaryBtn.setLayout(new BorderLayout());

    rbPrimary.setSelected(true);
    rbPrimary.setText("");
    rbPrimary.addActionListener(this);

    btnPrimary.setBackground(Color.white);
    btnPrimary.setText("");

    pnlPrimaryMunsell.setLayout(new BorderLayout());

    txtPrimaryMunsell.setEditable(false);
    txtPrimaryMunsell.setText("");
    txtPrimaryMunsell.setColumns(8);

    pnlPrimaryColor.setLayout(new BorderLayout());

    txtPrimary.setEditable(false);
    txtPrimary.setText("");

    // Secondary Rock Color Panel

    pnlSecondary.setBorder(titledBorderSecondary);
    pnlSecondary.setLayout(new GridLayout(2,1));

    pnlSecondaryBtn.setLayout(new BorderLayout());

    rbSecondary.setText("");
    rbSecondary.addActionListener(this);

    btnSecondary.setBackground(Color.white);
    btnSecondary.setText("");

    pnlSecondaryMunsell.setLayout(new BorderLayout());

    txtSecondaryMunsell.setEditable(false);
    txtSecondaryMunsell.setText("");
    txtSecondaryMunsell.setColumns(8);

    pnlSecondaryColor.setLayout(new BorderLayout());

    txtSecondary.setEditable(false);
    txtSecondary.setText("");

    // Streak Color Panel

    pnlStreaks.setBorder(titledBorderStreaks);
    pnlStreaks.setLayout(new GridLayout(2,1));

    pnlStreaksBtn.setLayout(new BorderLayout());

    rbStreaks.setText("");
    rbStreaks.addActionListener(this);

    btnStreaks.setBackground(Color.white);
    btnStreaks.setText("");

    pnlStreaksMunsell.setLayout(new BorderLayout());

    txtStreaksMunsell.setEditable(false);
    txtStreaksMunsell.setText("");
    txtStreaksMunsell.setColumns(8);

    pnlStreaksColor.setLayout(new BorderLayout());

    txtStreaks.setEditable(false);
    txtStreaks.setText("");

    // Attach Widgets to Panel

//    this.add(pnlNeutrals,  BorderLayout.SOUTH);
//    pnlNeutrals.add(btnN1, null);
//    pnlNeutrals.add(btnN2, null);
//    pnlNeutrals.add(btnN3, null);
//    pnlNeutrals.add(btnN4, null);
//    pnlNeutrals.add(btnN5, null);
//    pnlNeutrals.add(btnN6, null);
//    pnlNeutrals.add(btnN7, null);
//    pnlNeutrals.add(btnN8, null);
//    pnlNeutrals.add(btnN9, null);

    this.add(pnlCenter,                          BorderLayout.CENTER);
    pnlCenter.add(pnlButtons,                    BorderLayout.SOUTH);

//    pnlButtons.add( pnlDepthRange,               null );
    pnlButtons.add( pnlStart,                    null );
    pnlStart.add( txtStart,                      BorderLayout.CENTER );

    pnlButtons.add( pnlEnd,                      null );
    pnlEnd.add( txtEnd,                          BorderLayout.CENTER );

    pnlButtons.add(pnlAdd,                       null);
    pnlAdd.add(btnAdd,                           null);

    pnlAdd.add(pnlClear,                         null);
//    pnlClear.add(btnCancel,                      null);
    pnlClear.add(btnClear,                       null);

    pnlCenter.add(pnlText,                       BorderLayout.CENTER);
    pnlText.add(pnlPrimary,                      null);
    pnlPrimary.add(pnlPrimaryBtn,                null);
    pnlPrimaryBtn.add(rbPrimary,                 BorderLayout.WEST);
    pnlPrimaryBtn.add(btnPrimary,                BorderLayout.CENTER);
    pnlPrimaryBtn.add(pnlPrimaryMunsell,         BorderLayout.EAST);
//    pnlPrimary.add(pnlPrimaryMunsell,            null);
    pnlPrimaryMunsell.add(txtPrimaryMunsell,     BorderLayout.CENTER);
    pnlPrimary.add(pnlPrimaryColor,              null);
    pnlPrimaryColor.add(txtPrimary,              BorderLayout.CENTER);

    pnlText.add(pnlSecondary,                    null);
    pnlSecondary.add(pnlSecondaryBtn,            null);
    pnlSecondaryBtn.add(rbSecondary,             BorderLayout.WEST);
    pnlSecondaryBtn.add(btnSecondary,            BorderLayout.CENTER);
    pnlSecondaryBtn.add(pnlSecondaryMunsell,     BorderLayout.EAST);
//    pnlSecondary.add(pnlSecondaryMunsell,        null);
    pnlSecondaryMunsell.add(txtSecondaryMunsell, BorderLayout.CENTER);
    pnlSecondary.add(pnlSecondaryColor,          null);
    pnlSecondaryColor.add(txtSecondary,          BorderLayout.CENTER);

    pnlText.add(pnlStreaks,                      null);
    pnlStreaks.add(pnlStreaksBtn,                null);
    pnlStreaksBtn.add(rbStreaks,                 BorderLayout.WEST);
    pnlStreaksBtn.add(btnStreaks,                BorderLayout.CENTER);
    pnlStreaksBtn.add(pnlStreaksMunsell,         BorderLayout.EAST);
//    pnlStreaks.add(pnlStreaksMunsell,            null);
    pnlStreaksMunsell.add(txtStreaksMunsell,     BorderLayout.CENTER);
    pnlStreaks.add(pnlStreaksColor,              null);
    pnlStreaksColor.add(txtStreaks,              BorderLayout.CENTER);

    groupColor.add(rbPrimary);
    groupColor.add(rbSecondary);
    groupColor.add(rbStreaks);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getData()
   * <p> This method will return the selected colors
   * @return stColor = the color data structure
   */

  public rockColorStruct getData()
  {
    if (stColor == null)
    {
      stColor = new rockColorStruct();
      stColor.sKEY = new String(cmn.cmnString.UniqueName());
    }

    stColor.depthStart = dStart;
    stColor.depthEnd   = dEnd;

    stColor.iTotal = 0;
    for (int i=0; i<3; i++)
    {
      stColor.sColor[i]   = new String(sColor[i]);
      stColor.sMunsell[i] = new String(sMunsell[i].trim());
      stColor.sRGBHex[i]  = new String(sRGBHex[i]);

      if (stColor.iRGB[i][0] > -1)
        stColor.iTotal++;

      for (int j=0; j<3; j++)
      {
        if (iRGB[i][j] > 255) iRGB[i][j] = 255;
        stColor.iRGB[i][j] = iRGB[i][j];
      }
    }

    return (stColor);
  }

  /** Method getColor()
   * <p> This method will retrieve the color selection from the color plot
   * @param iColor  = the color ID that is passed
   * @param iRGBClr = RGB Color
   * @param sMun    = Munsell Color Code
   * @param sName   = Color Name
   * @param sHex    = RGB Hex
   */

  public void getColor( int iColor, int iRGBClr[],
                        String sMun, String sName, String sHex )
  {
    int iRed   = 0;
    int iGreen = 0;
    int iBlue  = 0;

    iRed    = iRGBClr[0];
    iGreen  = iRGBClr[1];
    iBlue   = iRGBClr[2];

    switch (iButton)
    {
      case _PRIMARY:
        iRGB[0][0]  = iRed;
        iRGB[0][1]  = iGreen;
        iRGB[0][2]  = iBlue;
        sMunsell[0] = new String( sMun );
        sColor[0]   = new String( sName );
        sRGBHex[0]  = new String( sHex );
        break;

      case _SECONDARY:
        iRGB[1][0]  = iRed;
        iRGB[1][1]  = iGreen;
        iRGB[1][2]  = iBlue;
        sMunsell[1] = new String( sMun );
        sColor[1]   = new String( sName );
        sRGBHex[1]  = new String( sHex );
        break;

      case _STREAKS:
        iRGB[2][0]  = iRed;
        iRGB[2][1]  = iGreen;
        iRGB[2][2]  = iBlue;
        sMunsell[2] = new String( sMun );
        sColor[2]   = new String( sName );
        sRGBHex[2]  = new String( sHex );
        break;
    }

    setWidgets();
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setMainScreen()
   * <p> This method will set the Main Dialogs Screen Location and Size
   * @param iXStart = the x-coordinate of Data entry dialog
   * @param iYStart = the y-coordinate of Data entry dialog
   * @param iWidth  = the width of Data entry dialog
   * @param iHeight = the height of Data entry dialog
   */

   public void setMainScreen(int iXStart, int iYStart, int iWidth, int iHeight)
   {
     this.iXStart = iXStart;
     this.iYStart = iYStart;
     this.iWidth  = iWidth;
     this.iHeight = iHeight;
   }

  /** Method setDepthRange(double depthStart, double depthEnd)
   * <p> This method will set the depth range of the data
   * @param depthStart = the starting depth
   * @param depthEnd   = the ending depth
   */

  public void setDepthRange(double depthStart, double depthEnd)
  {
    this.dStart = depthStart;
    txtStart.setText( "" + this.dStart );

    this.dEnd = depthEnd;
    txtEnd.setText( "" + this.dEnd );
  }

  /** Method setData()
   * <p> This method will set the Color Data Structure to be modified
   * @param stColor = the color data structure
   */

  public void setData(rockColorStruct stColor)
  {
    this.stColor = stColor;

    // Rock Color Variables

    for (int i=0; i<3; i++)
    {
      this.sColor[i]   = new String(stColor.sColor[i]);
      this.sMunsell[i] = new String(stColor.sMunsell[i]);
      this.sRGBHex[i]  = new String(stColor.sRGBHex[i]);

      for (int j=0; j<3; j++)
      {
        this.iRGB[i][j] = stColor.iRGB[i][j];
      }
    }

//    btnCancel.setEnabled(true);

    setWidgets();
    btnAdd.setText("Modify");
  }

  /** Method setWidgets()
   * <p> This method will set the panel widgets
   */

  private void setWidgets()
  {
    rbSecondary.setSelected(false);
    rbStreaks.setSelected(false);
    rbPrimary.setSelected(true);

    // Primary Rock Color Panel

    btnPrimary.setBackground(Color.white);
    if (iRGB[0][0] > -1)
      btnPrimary.setBackground(new Color(iRGB[0][0], iRGB[0][1], iRGB[0][2]));

    txtPrimaryMunsell.setText(sMunsell[0]);
    txtPrimary.setText(sColor[0]);

    // Secondary Rock Color Panel

    btnSecondary.setBackground(Color.white);
    if (iRGB[1][0] > -1)
      btnSecondary.setBackground(new Color(iRGB[1][0], iRGB[1][1], iRGB[1][2]));

    txtSecondaryMunsell.setText(sMunsell[1]);
    txtSecondary.setText(sColor[1]);

    // Streak Color Panel

    btnStreaks.setBackground(Color.white);
    if (iRGB[2][0] > -1)
      btnStreaks.setBackground(new Color(iRGB[2][0], iRGB[2][1], iRGB[2][2]));

    txtStreaksMunsell.setText(sMunsell[2]);
    txtStreaks.setText(sColor[2]);
  }

  /** Method setNeutralColor()
   * <p> This method will retrieve the Neutral color selection from the color plot
   * @param iColor = the Color ID
   */

  public void setNeutralColor(int iColor)
  {
    int iRed   = 0;
    int iGreen = 0;
    int iBlue  = 0;

    iRed = rock.color.rockColorUtility.getColor(0,
                    rock.color.rockMunsellColorStruct.COLORS[iColor][
                      rock.color.rockMunsellColorStruct._RGB_HEX]);
    iGreen = rock.color.rockColorUtility.getColor(1,
                    rock.color.rockMunsellColorStruct.COLORS[iColor][
                      rock.color.rockMunsellColorStruct._RGB_HEX]);
    iBlue = rock.color.rockColorUtility.getColor(2,
                    rock.color.rockMunsellColorStruct.COLORS[iColor][
                      rock.color.rockMunsellColorStruct._RGB_HEX]);

    switch (iButton)
    {
      case _PRIMARY:
        iRGB[0][0]  = iRed;
        iRGB[0][1]  = iGreen;
        iRGB[0][2]  = iBlue;
        sMunsell[0] = new String(
            rock.color.rockMunsellColorStruct.COLORS[iColor][
                      rock.color.rockMunsellColorStruct._MUNSELL_CODE]);
        sColor[0]   = new String(
            rock.color.rockMunsellColorStruct.COLORS[iColor][
                      rock.color.rockMunsellColorStruct._ISCC_COLOR]);
        sRGBHex[0]  = new String(
            rock.color.rockMunsellColorStruct.COLORS[iColor][
                      rock.color.rockMunsellColorStruct._RGB_HEX]);
        break;

      case _SECONDARY:
        iRGB[1][0]  = iRed;
        iRGB[1][1]  = iGreen;
        iRGB[1][2]  = iBlue;
        sMunsell[1] = new String(
            rock.color.rockMunsellColorStruct.COLORS[iColor][
                      rock.color.rockMunsellColorStruct._MUNSELL_CODE]);
        sColor[1]   = new String(
            rock.color.rockMunsellColorStruct.COLORS[iColor][
                      rock.color.rockMunsellColorStruct._ISCC_COLOR]);
        sRGBHex[1]  = new String(
            rock.color.rockMunsellColorStruct.COLORS[iColor][
                      rock.color.rockMunsellColorStruct._RGB_HEX]);
        break;

      case _STREAKS:
        iRGB[2][0]  = iRed;
        iRGB[2][1]  = iGreen;
        iRGB[2][2]  = iBlue;
        sMunsell[2] = new String(
            rock.color.rockMunsellColorStruct.COLORS[iColor][
                      rock.color.rockMunsellColorStruct._MUNSELL_CODE]);
        sColor[2]   = new String(
            rock.color.rockMunsellColorStruct.COLORS[iColor][
                      rock.color.rockMunsellColorStruct._ISCC_COLOR]);
        sRGBHex[2]  = new String(
            rock.color.rockMunsellColorStruct.COLORS[iColor][
                      rock.color.rockMunsellColorStruct._RGB_HEX]);
       break;
    }

    setWidgets();
  }

  /* =============================================================== *
   * ------------------ DISPLAY AVAILABLE COLORS ------------------- *
   * =============================================================== */

  /** Method displayColors()
   * <p> This method will display the available colors frame
   *

  public void displayColors()
  {
    closeColors();
    plotColors = new rockColorChartPlotFrame( obsrvble,
                                              stStruct,
                                              iXStart, iYStart,
                                              iWidth, iHeight );
  }
*/
  /** Method closeColors()
   * <p> This method will dispose of the available fossils frame
   *

  public void closeColors()
  {
    if (plotColors != null)
      plotColors.close();
    plotColors = null;
  }
*/
  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** Method add()
   * <p> This method will build the rock color data structure and signal to
   *     add or modify depending on the settings.
   */

  private void add()
  {
	if (notifier != null)
      notifier.notifyObservers(new String("ADD or MODIFY Rock Color Data"));
  }

  /** Method cancel()
   * <p> This method will cancel the edit
   */

  public void cancel()
  {
	if (notifier != null)
      notifier.notifyObservers(new String("Cancel Edit"));
  }

  /** Method clear()
   * <p> This method will clear the textfields
   */

  public void clear()
  {
    iButton = _PRIMARY;

    if (stColor != null)
      stColor.delete();
    stColor = null;

    // Rock Color Variables

    for (int i=0; i<3; i++)
    {
      sColor[i]   = new String("");
      sMunsell[i] = new String("");
      sRGBHex[i]  = new String("");

      for (int j=0; j<3; j++)
      {
        iRGB[i][j] = -1;
      }
    }

    setWidgets();
//    btnAdd.setText("Add");
  }

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
    notifier   = null;  // Observable Object

    if (stColor != null)
      stColor.delete();
    stColor = null;

    iRGB     = null;

    sColor   = null;
    sMunsell = null;
    sRGBHex  = null;

//    closeColors();

    // Neutral Color Buttons

//    btnN9 = null;
//    btnN8 = null;
//    btnN7 = null;
//    btnN6 = null;
//    btnN5 = null;
//    btnN4 = null;
//    btnN3 = null;
//    btnN2 = null;
//    btnN1 = null;

    // Add Color Selection to list

    btnAdd    = null;
    btnClear  = null;
    btnCancel = null;

    // Primary Rock Color Widgets

    rbPrimary          = null;
    btnPrimary         = null;   // View Color
    txtPrimaryMunsell  = null;   // Munsell Code
    txtPrimary         = null;   // ISCC Name

    // Secondary Rock Color Widgets

    rbSecondary         = null;
    btnSecondary        = null;   // View Color
    txtSecondaryMunsell = null;   // Munsell Code
    txtSecondary        = null;   // ISCC Name

    // Streaks Color Widgets

    rbStreaks           = null;
    btnStreaks          = null;   // View Color
    txtStreaksMunsell   = null;   // Munsell Code
    txtStreaks          = null;   // ISCC Name
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    if ( event.getSource() == btnAdd  )   { add(); }
    if ( event.getSource() == btnClear )  { clear(); }
    if ( event.getSource() == btnCancel ) { cancel(); }

//    if ( event.getSource() == btnN9 ) { setNeutralColor(8); }
//    if ( event.getSource() == btnN8 ) { setNeutralColor(7); }
//    if ( event.getSource() == btnN7 ) { setNeutralColor(6); }
//    if ( event.getSource() == btnN6 ) { setNeutralColor(5); }
//    if ( event.getSource() == btnN5 ) { setNeutralColor(4); }
//    if ( event.getSource() == btnN4 ) { setNeutralColor(3); }
//    if ( event.getSource() == btnN3 ) { setNeutralColor(2); }
//    if ( event.getSource() == btnN2 ) { setNeutralColor(1); }
//    if ( event.getSource() == btnN1 ) { setNeutralColor(0); }

    if ( event.getSource() == rbPrimary )   { iButton = _PRIMARY; }
    if ( event.getSource() == rbSecondary ) { iButton = _SECONDARY; }
    if ( event.getSource() == rbStreaks )   { iButton = _STREAKS; }
  }

  /** METHOD focusLost()
   *  <p> This Method will handle the lost focus event for the text fields.
   *  @param e      = Focus Lost Event
   */

  protected void focusLost(FocusEvent e)
  {
    int    iNumeric = 0;
    String sMessage = new String("");
    String sTemp    = new String("");

    if (e.getSource() == txtStart)
    {
      iNumeric = 1;
      sTemp = txtStart.getText();
      sMessage = new String("Start Depth Value is a Numeric Field");
    }

    if (e.getSource() == txtEnd)
    {
      iNumeric = 1;
      sTemp = txtEnd.getText();
      sMessage = new String("End Depth Value is a Numeric Field");
    }

    if (iNumeric == 1)
    {
      if (!cmn.cmnString.isNumeric(sTemp))
      {
        JOptionPane.showMessageDialog((Component) null,
                                       sMessage,
                                       "ERROR",
                                       JOptionPane.ERROR_MESSAGE);
      }
      else
      {
        if (e.getSource() == txtStart)
          dStart = cmn.cmnString.stringToDouble(txtStart.getText());

        if (e.getSource() == txtEnd)
          dEnd = cmn.cmnString.stringToDouble(txtEnd.getText());

//        setDepthRange( dStart, dEnd );
      }
    }
  }

  /* ===================================================================== *
   * ----------------------- OBSERVABLE ACTIONS -------------------------- *
   * ===================================================================== */

  /** Method update()
   * <p> This method will handle the Observable Actions
   * @param obj = The Observable making the call
   * @param arg = The returned object
   */

  public void update(Observable obj, Object arg)
  {
    String sArg = new String( (String) arg);

//    if (sArg.equals("Color Selected")) { getColor(); }

    if (notifier != null) notifier.notifyObservers(new String("MEMORY CHANGE"));
  }
}

/** CLASS rockColorDataEntryPanelFocusAdapter()
  *  <p> This Method will handle Actions when focus is lost on a textfield
  */

class rockColorDataEntryPanelFocusAdapter extends java.awt.event.FocusAdapter
{
  rockColorDataEntryPanel adaptee;

  rockColorDataEntryPanelFocusAdapter(rockColorDataEntryPanel adaptee)
  {
    this.adaptee = adaptee;
  }

  public void focusLost(FocusEvent e) { adaptee.focusLost(e); }
}

/** CLASS rockColorDataEntryPanelObservable()
  *  <p> This Class will handle Observable Actions when action occurs on a
  *      frame or panel
  */

class rockColorDataEntryPanelObservable extends Observable
{
  public void notifyObservers(Object b)
  {
    setChanged();
    super.notifyObservers(b);
  }
}

/*
 *  @version 1.1 09/10/2008
 *  @author  John Victorine
 */
