/*
 * @rockColorChartPlotPanel.java Version 1.1 11/10/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package rock.color.gui;

import java.util.Observable;
import java.awt.*;
import java.awt.image.*;
import javax.swing.*;

import iqstrat.iqstratStruct;
import rock.color.plot.rockColorChartPlot;

/** Class rockColorChartPlotPanel
 *  <p> This Class will display the rock colour chart by hue.
 *
 *  @version 1.1 11/10/2009
 *  @author  John R. Victorine
 */

public class rockColorChartPlotPanel extends Panel
{
  private JFrame        parent   = null; // Frame callint this panel
  private Observable    notifier = null; // Observable Object
  private iqstratStruct stStruct = null; // Global IQSTRAT Data Structure

  private int    iWidth  = 0;                    // Width of the plot panel
  private int    iHeight = 0;                    // Height of the plot panel

  private rockColorChartPlot plot = null;       // Rock Color Chart Plot Package

  private ScrollPane  scroll = new ScrollPane(); // Scroll Pane
  private JPanel      panel  = new JPanel();     // Panel containing plot

  /** Constructor rockColorChartPlotPanel()
   *  <p> This is the Constructor for this class.
   *  @param parent   = the frame calling this panel
   *  @param notifier = Observable Object
   *  @param stStruct = The Global IQSTRAT Data Structure
   */

  public rockColorChartPlotPanel( JFrame parent,
                                  Observable notifier,
                                  iqstratStruct stStruct)
  {
    try
    {
      this.parent   = parent;
      this.notifier = notifier;
      this.stStruct = stStruct;

      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Frame for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    Panel pnlCenter = new Panel();

    this.setLayout(new BorderLayout());
    pnlCenter.setLayout(new BorderLayout());

    plot    = new rockColorChartPlot( notifier, stStruct );
    iWidth  = plot.getPlotWidth();
    iHeight = plot.getPlotHeight();

    panel.setLayout(new BorderLayout());
    panel.setPreferredSize(new Dimension(iWidth, iHeight));
    panel.setBackground(Color.white);

    this.add(pnlCenter,   BorderLayout.CENTER);
    pnlCenter.add(scroll, BorderLayout.CENTER);
    scroll.add(panel,     null);
    panel.add(plot,       BorderLayout.CENTER);
  }

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
    parent   = null;
    notifier = null;
    scroll   = null;
    panel    = null;
    plot     = null;
  }

  /* =============================================================== *
   * ------------------------- GET METHODS ------------------------- *
   * =============================================================== */

  /** Method getColorID()
   * <p> This method will return color identifier
   * @return iColor = the color identifier or the row number in the lookup table
   */

  public int    getColorID() { return (plot.getColorID()); }

  /** Method getMunsellCode()
   * <p> This method will return the Munsell Code
   * @return sMunsellCode = the Munsell Code
   */

  public String getMunsellCode() { return (plot.getMunsellCode()); }

  /** Method getColorName()
   * <p> This method will return the ISCC Color Name.
   * @return sColor = The ISCC Color Name
   */

  public String getColorName() { return (plot.getColorName()); }

  /** Mthod getRGBHex()
   * <p> This method will return the RGB Hex String
   * @return sHex = The RGB Hex String
   */

  public String getRGBHex() { return (plot.getRGBHex()); }

  /** Mthod getRGB()
   * <p> This method will return the RGB Values
   * @return iRGB = The RGB Values
   */

  public int[] getRGB() { return (plot.getRGB()); }

  /* =============================================================== *
   * ------------------------- SET METHODS ------------------------- *
   * =============================================================== */

  /** Method setCatalog( int iCatalog )
   * <p> This method will set the type of catalog to display
   * @param iCatalog = the catalog to display
   */

  public void setCatalog( int iCatalog ) { plot.setCatalog( iCatalog ); }

  /** Method setHue(int iHue)
   * <p> This method will set the Hue to plot
   * @param iHue = the color hue identifier
   */

  public void setHue(int iHue) { plot.setHue( iHue ); }

  /** Method setHueNo(int iHueNo)
   * <p> This method will set the Hue Number to plot
   * @param iHueNo = the color hue number
   */

  public void setHueNo( int iHueNo ) { plot.setHueNo( iHueNo); }
}