/*
 * @pfefferStruct.java Version 1.1 01/07/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 *
 * Defines "structure" for parameters controlling water saturation computations.
 *   Archie equation uses A, M, N, Rw
 *   Simandoux uses A, M, N, Rw, Rsh, Phish?
 *   Dual water uses A, M, N, Rw, Rklkjlkjlkj?
 *
 * @original version 1.00 09 Jan 2000
 * @author Geoff Bohling
 */

package pfeffer;

public class pfefferStruct
{
  // Archie Equation Parameters

  public double A     = 0.0; // Archie multiplication factor
  public double M     = 0.0; // Cementation factor
  public double N     = 0.0; // Saturation exponent
  public double Rw    = 0.0; // Formation water resistivity
  public double Rsh   = 0.0; // Shale resistivity
  public double Phish = 0.0; // Shale porosity

  // Moveable Hydrocarbon Parameters

  public double depth = 0.0; // Formation Depth
  public double Rmf   = 0.0; // Mud Filtrate
  public double Rmft  = 0.0; // Mud Filtrate Resistivity Temperature (Rmft)
  public double ST    = 0.0; // Surface Temperature (ST)
  public double BHT   = 0.0; // Bore Hole Temperature (BHT)
  public double TD    = 0.0; // Total Depth (TD)

  public int    iTemp = pfeffer.pfefferDataStruct.FAHRENHEIT; // Temperature Unit

  // Computed Variables

  public double Rtc = 0.0; // Corrected resistivity (same as input Rt for Archie)
  public double Rwa = 0.0; // Apparent formation water resistivity (for Sw=100%)
  public double Ro  = 0.0; // Resistivity at 100% saturation
  public double Ma  = 0.0; // Apparent cementation exponent (for Sw=100%)
  public double Sw  = 0.0; // Water saturation itself
  public double BVW = 0.0; // Bulk volume water (Sw*porosity)

  public double Sxo = 0.0; // Saturation Moveable Fluid
  public double BVF = 0.0; // Bulk volume fluid (Sxo*porosity)
}
