/*
 * @pfefferDataListStruct.java Version 1.1 01/07/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 *
 * @version 1.00 09 Jan 2000
 * @author John R. Victorine
 */

package pfeffer;

import iqstrat.iqstratHeadersStruct;
import pfeffer.pfefferDataStruct;

public class pfefferDataListStruct
{
  public iqstratHeadersStruct stHeader = null;

  public double depthStart = 0.0;  // Starting Depth
  public double depthEnd   = 0.0;  // Ending Depth

  public String sKGS       = "NO"; // KGS Saved Data Indicator
  public String source     = "";   // Source of Data
  public String sCreated   = "";   // Created Date
  public String savedLast  = "";   // Latest Save Date

  public int               iCount   = 0;    // Total Number of Records
  public pfefferDataStruct stItem[] = null; // Array of pfeffer data structures

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    if (stHeader != null)
      stHeader.delete();
    stHeader = null;

    sKGS      = null;   // KGS Saved Data Indicator
    source    = null;   // Source of Data
    sCreated  = null;   // Created Date
    savedLast = null;   // Latest Save Date

    if (iCount > 0)
    {
      for (int i=0; i<iCount; i++)
      {
        if (stItem[i] != null)
          stItem[i].delete();
      }
    }

    iCount = 0;
    stItem = null;
  }

}
