/*
 * @parseTextureStruct.java Version 1.1 09/28/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

/** Class parseTextureStruct
 *  <p> This Class holds the Lithology Symbol Identifier & colors and any
 *      descriptors to the basic lithology.
 *
 *  @version 1.1 09/28/2009
 *  @author  John R. Victorine
 */

public class parseTextureStruct
{
  // Texture Lithology

  public int    id      = 0;   // ID for Lithology Symbol
  public String sID     = "0"; // String ID for Lithology Symbol
  public String sName   = "";  // Name or Description of lithology
  public String sAbrev  = "";  // Abbreviation of lithology

  // Lithology Symbol & Background color

  public int iSymbol = lith.lithology.lithologySymbolsStruct._NONE; // Lithology
  public int iRGB[]  = { 255, 255, 255 }; // RGB Color

  // Misc variables

  public int    iEnergy = 0;    // Energy Level
  public int    iType   = lith.texture.textureConstants.NONE; // Type of Texture

  // Mineral Composition

  public String sPrimary   = "";
  public String sSecondary = "";
  public String sOther     = "";
  public double dPercent   = 20.0; //0.2;

  public double density = 0.0;  // Grain Density (Rhomaa)
  public double dU      = 0.0;  // Photoelectric Factor (Umaa)
  public double dGR     = 0.0;  // Gamma Ray (API)

  // List of descriptors modifing basic lithology

  public int                iCount        = 0;
  public parseTextureStruct descriptors[] = null;

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    // Texture - lithology

    sID        = null; // String ID for Lithology Symbol
    sName      = null; // Name or Description of lithology
    sAbrev     = null; // Abbreviation of lithology

    sPrimary   = null;
    sSecondary = null;
    sOther     = null;

    // Background color

    iRGB       = null; // RGB Background Color

    // List of descriptors modifing basic lithology

    if (iCount != 0)
    {
      for (int i=0; i<iCount; i++)
      {
        if (descriptors[i] != null)
          descriptors[i].delete();
        descriptors[i] = null;
      }
    }
  }
}