/*
 * @parseSedStructStruct.java Version 1.1 10/01/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

/** Class parseSedStructStruct
 *  <p> This Class holds the Sedimentary Structure Thesaurus.
 *
 *  @version 1.1 10/01/2009
 *  @author  John R. Victorine
 */

public class parseSedStructStruct
{
  // SedStruct Lithology

  public String sID     = "0"; // String ID for Sedimentary Structure Symbol
  public String sPhrase = "";  // Key Word of Sedimentary Structure
  public String sName   = "";  // Name or Description of Sedimentary Structure
  public String sAbrev  = "";  // Abbreviation of Sedimentary Structure

  // List of descriptors modifing basic lithology

  public int                  iCount        = 0;
  public parseSedStructStruct descriptors[] = null;

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    // SedStruct - lithology

    sID        = null; // String ID for Lithology Symbol
    sPhrase    = null; // Key Word of Sedimentary Structure
    sName      = null; // Name or Description of lithology
    sAbrev     = null; // Abbreviation of lithology

    // List of descriptors modifing basic lithology

    if (iCount != 0)
    {
      for (int i=0; i<iCount; i++)
      {
        if (descriptors[i] != null)
          descriptors[i].delete();
        descriptors[i] = null;
      }
    }
  }
}