/*
 * @parseSedStructListStruct.java Version 1.1 10/01/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

import parse.parseSedStructStruct;

/** Class parseSedStructListStruct
 *  <p> This Class holds all the words & pharses for the sedimentary structure
 *      plot track.
 *
 *  @version 1.1 10/01/2009
 *  @author  John R. Victorine
 */

public class parseSedStructListStruct
{
  // Abbreviations

  public int    iAbbrev       = 0;    // total number of records
  public String sAbbrev[][]   = null; // Abreviation {Abbrev, word }

  // Modifiers

  public int    iModifiers    = 0;    // total number of records
  public String sModifier[][] = null; // Modifier List { Modifier, Modifies, phrase }

  // Keywords

  public int    iKeywords     = 0;    // Total Number of Keywords
  public String sKeywords[][] = null; // Keyword List { pharase, type}

  // Minerals

  public int                  iCount   = 0;    // Total Number of Records
  public parseSedStructStruct stItem[] = null; // SedStructs Structure

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    // Abbreviations

    iAbbrev    = 0;    // total number of records
    sAbbrev    = null; // Abbreviation, word

    // Modifiers

    iModifiers = 0;    // total number of records
    sModifier  = null; // Modifier, Modifies, phrase

    // Keywords

    iKeywords  = 0;    // Total keywords
    sKeywords  = null; // keywords

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}
