/*
 * @parseRockColumnSymbolsStruct.java Version 1.1 08/01/2012
 *
 * Copyright (c) 2012 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

/** Class parseRockColumnSymbolsStruct
 *  <p> This Class holds the Rock Column Symbols Plot Data.
 *
 *  @version 1.1 08/01/2012
 *  @author  John R. Victorine
 */

public class parseRockColumnSymbolsStruct
{
  public String sID        = "";  // Rock Column Symbol ID
  public int    iGroup     = -1;  // Group Number
  public String sGroup     = "";  // The group the rock belongs
  public String sName      = "";  // Name or Description of rock
  public String sAbrev     = "";  // Abbreviation of rock

  public String sType      = "";  // Type of Lithology 1st (primary),
  public String sCycle     = "";  // sed (sedimentary), ign (igneous), etc.
  public int    iOrder     = 0;   // Order for lithology symbol to be plotted
  public int    iWeather   = 0;   // The number of times horizontal

  // Background color

  public int    iRGB[]     = { 255, 255, 255 };

  // Plot Symbol for lithology default is an empty or None symbol

  public int    iRows      = 10; // Total number of rows
  public int    iColumns   = 20; // Total number of columns within String
  public String symbol[][] = {   // Plot Symbol for Rock Column Bed
	//     Row Even Number         Row Odd Number
    {  "....................", "...................." },
    {  "....................", "...................." },
    {  "....................", "...................." },
    {  "....................", "...................." },
    {  "....................", "...................." },
    {  "....................", "...................." },
    {  "....................", "...................." },
    {  "....................", "...................." },
    {  "....................", "...................." },
    {  "....................", "...................." }
  };

  public static final int _NONE   = -1; // None
  public static final int _TOP    = 0; // Top of the Rock Column Cap
  public static final int _CENTER = 1; // General Rock Column Cap
  public static final int _BASE   = 2; // Base of the Rock Column Cap
  public static final int _ROW_l  = 3; // Each Row Even Row Rock Column Cap
  public static final int _ROW_r  = 4; // Each Row Odd Row Rock Column Cap

  public int    iCapRows = 10; // Total number of rows
  public int    iCaps    = 0;  // Total number of columns
  public int    iTypes[] = { _ROW_l, _ROW_r }; // What type and when to use
  public String caps[][] = { // Plot Symbol for Rock Column Bed Cap
    {  "..........", ".........." },
    {  "..........", ".........." },
    {  "..........", ".........." },
    {  "..........", ".........." },
    {  "..........", ".........." },
    {  "..........", ".........." },
    {  "..........", ".........." },
    {  "..........", ".........." },
    {  "..........", ".........." },
    {  "..........", ".........." }
  };

  // Thesaurus associated with symbols

  public int    iThesaurus   = 0;     // Total number of terms
  public String sThesaurus[] = null;  // List of terms associated with symbol
  public int    iType[]      = null;  // Order of abundance 0=trace, 4=extremely, etc.

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    sID        = null;  // Rock Column Symbol ID
    sGroup     = null;  // The group the rock belongs
    sName      = null;  // Name or Description of rock
    sAbrev     = null;  // Abbreviation of rock

    sType      = null;  // Type of Lithology 1st (primary), etc.
    sCycle     = null;  // sed (sedimentary), ign (igneous), etc.

    symbol     = null;
    iTypes     = null;
    caps       = null;

    sThesaurus = null;  // List of terms associated with symbol
    iType      = null;  // Order of abundance 0=trace, 4=extremely, etc.
  }
}

/*
 *  @version 1.1 08/01/2012
 *  @author  John Victorine
 */
