/*
 * @parseRockColumnSymbolsListStruct.java Version 1.1 08/01/2012
 *
 * Copyright (c) 2012 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

import parse.parseRockColumnSymbolsStruct;

import lith.lithology.lithologyColorsStruct;
import lith.lithology.lithologyGroupsStruct;

/** Class parseRockColumnSymbolsListStruct
 *  <p> This Class holds the Rock Column Symbols Plot Data List.
 *
 *  @version 1.1 08/01/2012
 *  @author  John R. Victorine
 */

public class parseRockColumnSymbolsListStruct
{
  // Rock Column Colors

  public lithologyColorsStruct  stForeground = null; // foreground colors
  public lithologyColorsStruct  stBackground = null; // background colors

  // Rock Column Groups

  public lithologyGroupsStruct  stGroups     = null; // Lithology Groups

  // Abbreviations

  public int    iAbbrev       = 0;    // total number of records
  public String sAbbrev[][]   = null; // Abreviation {Abbrev, word }

  // Modifiers

  public int    iModifiers    = 0;    // total number of records
  public String sModifier[][] = null; // Modifier List { Modifier, Modifies, phrase }

  // Keywords

  public int    iKeywords     = 0;    // Total Number of Keywords
  public String sKeywords[][] = null; // Keyword List { phrase, type}

  // Rock Column Symbol Structure Array

  public int                          iCount   = 0;    // Total Number of Records
  public parseRockColumnSymbolsStruct stItem[] = null; // Rock Column Symbols Structure

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    // Lithology Colors

    if (stForeground != null)
      stForeground.delete();
    stForeground = null; // foreground colors

    if (stBackground != null)
      stBackground.delete();
    stBackground = null; // background colors

    // Lithology Groups

    if (stGroups != null)
      stGroups.delete();
    stGroups = null;     // Rock Column Groups

    // Abbreviations

    iAbbrev    = 0;    // total number of records
    sAbbrev    = null; // Abbreviation, word

    // Modifiers

    iModifiers = 0;    // total number of records
    sModifier  = null; // Modifier, Modifies, phrase

    // Keywords

    iKeywords  = 0;    // Total keywords
    sKeywords  = null; // keywords

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}

/*
 *  @version 1.1 08/01/2012
 *  @author  John Victorine
 */
