/*
 * @parsePHIStruct.java Version 1.1 10/14/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

/** Class parsePHIStruct
 *  <p> This Class holds the Porosity Type Thesaurus.
 *
 *  @version 1.1 10/14/2009
 *  @author  John R. Victorine
 */

public class parsePHIStruct
{
  // Porosity Type

  public String sID     = "0"; // String ID for Porosity Type Symbol
  public String sPhrase = "";  // Key Word of Porosity Type

  // List of descriptors modifing basic Porosity Type

  public int            iCount        = 0;
  public parsePHIStruct descriptors[] = null;

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    // Porosity Types Identifiers

    sID        = null; // String ID for Porosity Type Symbol
    sPhrase    = null; // Key Word of Porosity Type

    // List of descriptors modifing basic fossils

    if (iCount != 0)
    {
      for (int i=0; i<iCount; i++)
      {
        if (descriptors[i] != null)
          descriptors[i].delete();
        descriptors[i] = null;
      }
    }
  }
}