/*
 * @parsePHIListStruct.java Version 1.1 10/14/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

import parse.parsePHIStruct;

/** Class parsePHIListStruct
 *  <p> This Class holds all the words & pharses for the Porosity Types plot track.
 *
 *  @version 1.1 10/14/2009
 *  @author  John R. Victorine
 */

public class parsePHIListStruct
{
  // Abbreviations

  public int    iAbbrev       = 0;    // total number of records
  public String sAbbrev[][]   = null; // Abreviation {Abbrev, word }

  // Modifiers

  public int    iModifiers    = 0;    // total number of records
  public String sModifier[][] = null; // Modifier List { Modifier, Modifies, phrase }

  // Keywords

  public int    iKeywords     = 0;    // Total Number of Keywords
  public String sKeywords[][] = null; // Keyword List { pharase, type}

  // Porosity Types Dictionary

  public int            iPorosity    = 0;    // Total Number of Records
  public parsePHIStruct stPorosity[] = null; // Porosity Types Data Structure

  // Porosity Types

  public int            iCount   = 0;    // Total Number of Records
  public parsePHIStruct stItem[] = null; // Porosity Types Data Structure

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    int i = 0;

    // Abbreviations

    iAbbrev    = 0;    // total number of records
    sAbbrev    = null; // Abbreviation, word

    // Modifiers

    iModifiers = 0;    // total number of records
    sModifier  = null; // Modifier, Modifies, phrase

    // Keywords

    iKeywords  = 0;    // Total keywords
    sKeywords  = null; // keywords

    for (i=0; i<iPorosity; i++)
    {
      if (stPorosity[i] != null)
        stPorosity[i].delete();
      stPorosity[i] = null;
    }

    iPorosity = 0;

    for (i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}
