/*
 * @parseMineralsStruct.java Version 1.1 12/11/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

/** Class parseMineralsStruct
 *  <p> This Class holds the standard well logging mineral data.
 *
 *  @version 1.1 12/11/2009
 *  @author  John R. Victorine
 */

public class parseMineralsStruct
{
  // Texture Lithology

  public String sName       = "";  // Name or Description of mineral
  public String sGroup      = "";  // Group name of mineral
  public String sClass      = "";  // Class name of mineral
  public String sFormula    = "";  // Mineral Formula
  public String sOccurrence = "";  // Mineral Occurrence

  public int    id          = 0;   // Plot Symbol

  // Schlumberger Measured & Calculated Data

  public double dMolWt     = 0.0; // Molecular weight, calculated from formula
  public double dRHOB      = 0.0; // Bulk Density, calculated from formula
  public double dRHOE      = 0.0; // Electron Density, calculated (gm/cc)
  public double dRHOL      = 0.0; // Litho Density, calculated (gm/cc)
  public double dPECalc    = 0.0; // Photoelectric Factor, calc (barns/electron)
  public double dPE        = 0.0; // Photoelectric Factor, meas (barns/electron)
  public double dU         = 0.0; // Volumetric Photoelectric Factor (barns/cc)   { u=rhoe*pe_calc }
  public double dSigmaCalc = 0.0; // Neutron Cross-section, calc from formula
  public double dSigma     = 0.0; // Neutron Cross-section, meas empirically
  public double dLs        = 0.0; // Neutron slowing-down length, calc from formula
  public double dLd        = 0.0; // Neutron diffusion length, calc from formula
  public double dCNLCalc   = 0.0; // Epithermal CNL porosity, calc from formula
  public double dCNL       = 0.0; // Epithermal CNL porosity, meas empirically
  public double dCNL_TCalc = 0.0; // Thermal CNL porosity, calc from formula
  public double dCNL_T     = 0.0; // Thermal CNL porosity, meas empirically
  public double dBulk      = 0.0; // Bulk Modulus, calculated from formula
  public double dShear     = 0.0; // Shear Modulus, calculated from formula
  public double dt_comp    = 0.0; // Delta-T Compressional (us/m), calc from formula
  public double dt_shear   = 0.0; // Delta-T Shear (us/m), calculated from formula
  public double dPoisson   = 0.0; // Poisson's Ratio, calculated from formula
  public double dEPT       = 0.0; // EPT Propagation time, calculated from formula

  // Computed Values for Colorlith and Compositional Analysis

  public double dRhomaa    = 0.0;  // Grain Density (Rhomaa)
  public double dUmaa      = 0.0;  // Photoelectric Factor (Umaa)
  public double dGR        = 0.0;  // Gamma Ray (API)

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    // Texture - lithology

    sName       = null; // Name or Description of lithology
    sGroup      = null; // Group name of mineral
    sClass      = null; // Class name of mineral
    sFormula    = null; // Mineral Formula
    sOccurrence = null; // Mineral Occurrence
  }
}