/*
 * @parseMineralsListStruct.java Version 1.1 12/11/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

import parse.parseMineralsStruct;

/** Class parseMineralsListStruct
 *  <p> This Class holds all the standard well logging mineral data.
 *
 *  @version 1.1 12/11/2009
 *  @author  John R. Victorine
 */

public class parseMineralsListStruct
{
  // Minerals

  public int                 iCount   = 0;    // Total Number of Records
  public parseMineralsStruct stItem[] = null; // Textures Structure

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}
