/*
 * @parseGrainsTextureStruct.java Version 1.1 02/03/2016
 *
 * Copyright (c) 2016 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

/** Class parseGrainsTextureStruct
 *  <p> This Class holds the Rock Column Symbols Plot Data.
 *
 *  @version 1.1 02/03/2016
 *  @author  John R. Victorine
 */

public class parseGrainsTextureStruct
{
  public String sID        = "";  // Rock Column Symbol ID
  public int    iGroup     = -1;  // Group Number
  public String sGroup     = "";  // The group the rock belongs
  public String sName      = "";  // Name or Description of rock
  public String sAbrev     = "";  // Abbreviation of rock

  public String sCycle     = "";  // sed (sedimentary), ign (igneous), etc.
  public int    iWeather   = 0;   // The number of times horizontal

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    sID        = null;  // Rock Column Symbol ID
    sGroup     = null;  // The group the rock belongs
    sName      = null;  // Name or Description of rock
    sAbrev     = null;  // Abbreviation of rock
    sCycle     = null;  // sed (sedimentary), ign (igneous), etc.
  }
}

/*
 *  @version 1.1 02/03/2016
 *  @author  John Victorine
 */
