/*
 * @parseGrainsTextureListStruct.java Version 1.1 02/03/2016
 *
 * Copyright (c) 2016 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

import parse.parseGrainsTextureStruct;

import lith.lithology.lithologyColorsStruct;
import lith.lithology.lithologyGroupsStruct;

/** Class parseGrainsTextureListStruct
 *  <p> This Class holds the Rock Column Symbols Plot Data List.
 *
 *  @version 1.1 02/03/2016
 *  @author  John R. Victorine
 */

public class parseGrainsTextureListStruct
{
  // Abbreviations

  public int    iAbbrev_main     = 0;    // total number of records
  public String sAbbrev_main[][] = null; // Abreviation Main {Abbrev, word }

  public int    iAbbrev_desc     = 0;    // total number of records
  public String sAbbrev_desc[][] = null; // Abreviation Descriptor {Abbrev, word }

  // Modifiers

  public int    iModifiers    = 0;    // total number of records
  public String sModifier[][] = null; // Modifier List { Modifier, Modifies, phrase }

  // Keywords

  public int    iKeywords     = 0;    // Total Number of Keywords
  public String sKeywords[][] = null; // Keyword List { phrase, type}

  // Rock Column Symbol Structure Array

  public int                      iCount   = 0;    // Total Number of Records
  public parseGrainsTextureStruct stItem[] = null; // Rock Column Symbols Structure

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    // Abbreviations

    iAbbrev_main = 0;    // total number of records
    sAbbrev_main = null; // Abbreviation Main

    iAbbrev_desc = 0;    // total number of records
    sAbbrev_desc = null; // Abbreviation Descriptor

    // Modifiers

    iModifiers = 0;    // total number of records
    sModifier  = null; // Modifier, Modifies, phrase

    // Keywords

    iKeywords  = 0;    // Total keywords
    sKeywords  = null; // keywords

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}

/*
 *  @version 1.1 02/03/2016
 *  @author  John Victorine
 */
