/*
 * @parseFossilStruct.java Version 1.1 10/14/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

/** Class parseFossilStruct
 *  <p> This Class holds the Fossil Thesaurus.
 *
 *  @version 1.1 10/14/2009
 *  @author  John R. Victorine
 */

public class parseFossilStruct
{
  // SedStruct Lithology

  public String sID     = "0"; // String ID for Fossil Symbol
  public String sPhrase = "";  // Key Word of Fossil

  // List of descriptors modifing basic fossil

  public int               iCount        = 0;
  public parseFossilStruct descriptors[] = null;

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    // Fossils Identifiers

    sID        = null; // String ID for Fossil Symbol
    sPhrase    = null; // Key Word of Fossil

    // List of descriptors modifing basic fossils

    if (iCount != 0)
    {
      for (int i=0; i<iCount; i++)
      {
        if (descriptors[i] != null)
          descriptors[i].delete();
        descriptors[i] = null;
      }
    }
  }
}