/*
 * @parseDepEnvStruct.java Version 1.1 11/01/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

/** Class parseDepEnvStruct
 *  <p> This Class holds the Depositional Environment Identifier & colors and any
 *      descriptors to the basic Enviroments.
 *
 *  @version 1.1 11/01/2011
 *  @author  John R. Victorine
 */

public class parseDepEnvStruct
{
  // Texture Lithology

  public String sName   = "";  // Name or Description of Depositional Environment

  // Misc variables

  public int    icontl    = 0;  // Continental
  public int    icstl     = 0;  // Coastal
  public int    ifrsh     = 0;  // Fresh Water
  public int    ibrcksh   = 0;  // Brackish Water
  public int    ishore    = 0;  // Shoreface
  public int    ioff_tran = 0;  // Off shore trasition
  public int    ioffshr   = 0;  // Off Shore
  public int    ishlf_m   = 0;  // Middle Neritic
  public int    ishlf_o   = 0;  // Outer Neritic
  public int    ibthyl_u  = 0;  // Upper Bathyal
  public int    ibthyl_m  = 0;  // Middle Bathyal
  public int    ibthyl_l  = 0;  // Lower Bathyal
  public int    iabyssl   = 0;  // Abyssal

  public String sType     = ""; // Type of Depositional Environment
  public int    iType     = -1; // ID for the Depositional Environment Type
  public String sGroup    = ""; // Group of Type of Depositional Environment
  public String sGroup2   = ""; // Group of a Group

  // List of descriptors modifing basic Depositional Environment

  public int               iCount        = 0;
  public parseDepEnvStruct descriptors[] = null;

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    // Depositional Environment

    sName      = null; // Name or Description of Depositional Environment
    sType      = null; // Type of Depositional Environment
    sGroup     = null; // Group of Type of Depositional Environment
    sGroup2    = null; // Group of a Group

    // List of descriptors modifing basic Depositional Environment

    if (iCount != 0)
    {
      for (int i=0; i<iCount; i++)
      {
        if (descriptors[i] != null)
          descriptors[i].delete();
        descriptors[i] = null;
      }
    }
  }
}

/*
 *  @version 1.1 11/02/2011
 *  @author  John Victorine
 */
