/*
 * @parseDepEnvListStruct.java Version 1.1 11/01/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

import parse.parseDepEnvStruct;

/** Class parseDepEnvListStruct
 *  <p> This Class holds all the words & pharses for the Depositional Environment plot track.
 *
 *  @version 1.1 11/01/2011
 *  @author  John R. Victorine
 */

public class parseDepEnvListStruct
{
  // Colors

  public int    iColors   = 0;    // total number of records
  public String sColors[] = null; // Color description
  public int    iRGB[][]  = null; // rgb values

  // Abbreviations

  public int    iAbbrev       = 0;    // total number of records
  public String sAbbrev[][]   = null; // Abreviation {Abbrev, word }

  // Modifiers

  public int    iModifiers    = 0;    // total number of records
  public String sModifier[][] = null; // Modifier List { Modifier, Modifies, phrase }

  // Keywords

  public int    iKeywords     = 0;    // Total Number of Keywords
  public String sKeywords[][] = null; // Keyword List { pharase, type}

  // Minerals

  public int                iCount   = 0;    // Total Number of Records
  public parseDepEnvStruct stItem[] = null; // Depositional Environments Structure

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    // Colors

    iColors    = 0;    // total number of records
    sColors    = null; // Color description
    iRGB       = null; // rgb values

    // Abbreviations

    iAbbrev    = 0;    // total number of records
    sAbbrev    = null; // Abbreviation, word

    // Modifiers

    iModifiers = 0;    // total number of records
    sModifier  = null; // Modifier, Modifies, phrase

    // Keywords

    iKeywords  = 0;    // Total keywords
    sKeywords  = null; // keywords

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}

/*
 *  @version 1.1 11/02/2011
 *  @author  John Victorine
 */
