/*
 * @parseColorStruct.java Version 1.1 10/12/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

/** Class parseColorStruct
 *  <p> This Class holds the Colors Thesaurus.
 *
 *  @version 1.1 10/12/2009
 *  @author  John R. Victorine
 */

public class parseColorStruct
{
  public static final int NO  = 0;
  public static final int YES = 1;

  // Color Lithology

  public String sID      = "0"; // String ID for Colors Symbol
  public String sPhrase  = "";  // Key Word of Colors

  public int    iRGB[]   = { 255, 255, 255 };
  public String sHex     = "#FFFFFF";

  public String sMunsell = "";

  // List of descriptors modifing basic lithology

  public int              iCount        = 0;
  public parseColorStruct descriptors[] = null;

  public int              iRockColor    = NO;
  public int              iSoilColor    = NO;

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    // Color - lithology

    sID        = null; // String ID for Lithology Symbol
    sPhrase    = null; // Key Word of Colors

    iRGB       = null;
    sHex       = null;
    sMunsell   = null;

    // List of descriptors modifing basic lithology

    if (iCount != 0)
    {
      for (int i=0; i<iCount; i++)
      {
        if (descriptors[i] != null)
          descriptors[i].delete();
        descriptors[i] = null;
      }
    }
  }
}