/*
 * @parseColorListStruct.java Version 1.1 10/12/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package parse;

import parse.parseColorStruct;

/** Class parseColorListStruct
 *  <p> This Class holds all the words & pharses for the Colors plot track.
 *
 *  @version 1.1 10/12/2009
 *  @author  John R. Victorine
 */

public class parseColorListStruct
{
  // Abbreviations

  public int    iAbbrev       = 0;    // total number of records
  public String sAbbrev[][]   = null; // Abreviation {Abbrev, word }

  // Modifiers

  public int    iModifiers    = 0;    // total number of records
  public String sModifier[][] = null; // Modifier List { Modifier, Modifies, phrase }

  // Keywords

  public int    iKeywords     = 0;    // Total Number of Keywords
  public String sKeywords[][] = null; // Keyword List { pharase, type}

  // Dictionary

  public int              iColors    = 0;    // Total Number of Colors
  public parseColorStruct stColors[] = null; // Colors Structure

  // Colors

  public int              iCount   = 0;    // Total Number of Records
  public parseColorStruct stItem[] = null; // Colors Structure

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    // Abbreviations

    iAbbrev    = 0;    // total number of records
    sAbbrev    = null; // Abbreviation, word

    // Modifiers

    iModifiers = 0;    // total number of records
    sModifier  = null; // Modifier, Modifies, phrase

    // Keywords

    iKeywords  = 0;    // Total keywords
    sKeywords  = null; // keywords

    for (int i=0; i<iColors; i++)
    {
      if (stColors[i] != null)
        stColors[i].delete();
      stColors[i] = null;
    }

    iColors = 0;

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}
