/*
 * @maskSymbolsStruct.java Version 1.1 07/20/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package mask;

/** Class maskSymbolsStruct
 *  <p> This Class holds the Lithology Symbol Plot Data.
 *
 *  @version 1.1 07/20/2009
 *  @author  John R. Victorine
 */

public class maskSymbolsStruct
{
  public static final int OFF = 0;
  public static final int ON  = 1;

  public int    iHierarchy = -1;  // Hierarchy within the list
                                  //  iHierarchy = 100 * iGroup + iOrder
  public int    id         =  0;  // ID for Lithology Symbol
  public String sID        = "0"; // String ID for Mask Symbol
  public int    iShow      = OFF; // Default Legend parameter
  public int    iExtend    = OFF; // Extended Legend parameter
  public int    iOrder     = -1;  // Order within the group
  public int    iGroup     = -1;  // Group Number
  public String sGroup     = "";  // The group the lithology belongs
  public String sName      = "";  // Name or Description of lithology
  public String sAbrev     = "";  // Abbreviation of lithology
  public String sMnemonic  = "";  // Mnemonic of lithology

  // Misc variables

  public String sType      = "";  // Type of Mask
  public String size       = "";  // Size Description
  public double dMinimum   = 0.0; // Minimum Size
  public double dMaximum   = 0.0; // Maximum Size

  // Background color

  public int    iRGB[]     = { 255, 255, 255 };

  // Plot Symbol for lithology default is an empty or None symbol

  public int    iRows      = 0;
  public int    iColumns   = 0;
  public String symbol[][] = null;

  // Lithology

  public int iLithology[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

  // Thesaurus for searching and parsing geologist field notes or comments

  public int    iThesaurus   = 0;
  public String sThesaurus[] = null;

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    id         =  0;    // ID for Mask Symbol
    sID        = null;  // String ID for Mask Symbol
    iShow      = OFF;   // Default Legend parameter
    iExtend    = OFF;   // Extended Legend parameter
    iOrder     = -1;    // Order within the group
    iGroup     = -1;    // Group Number
    sGroup     = null;  // The group the Mask belongs
    sName      = null;  // Name or Description of Mask
    sAbrev     = null;  // Abbreviation of Mask
    sMnemonic  = null;  // Mnemonic of Mask

    // Misc variables

    sType      = null;  // Type of Mask
    size       = null;  // Size Description

    // Background color

    iRGB       = null;

    // Plot Symbol for Mask default is an empty or None symbol

    iRows      =  0;
    iColumns   =  0;
    symbol     = null;

    // Lithology

    iLithology = null;

    // Thesaurus for searching and parsing geologist field notes or comments

    iThesaurus = 0;
    sThesaurus = null;
  }
}